# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['IndependentAmountEligibilityEnum']

class IndependentAmountEligibilityEnum(Enum):
    """
    The enumerated values to specify the instances where the independent amount eligible collateral is not defined as a set of eligible collateral assets.
    """
    NONE = "None"
    """
    None.
    """
    NONE_UNLESS_SPECIFIED_IN_CONFIRMATION = "NoneUnlessSpecifiedInConfirmation"
    """
    None, unless otherwise specified in a Confirmation.
    """
