# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FrenchLawAddendumElection']


class FrenchLawAddendumElection(BaseDataClass):
    """
    A class to specify party specific French Law Addendum language.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    isApplicable: bool = Field(..., description="The qualification of whether the party elects specific language.")
    """
    The qualification of whether the party elects specific language.
    """
    addendumLanguage: Optional[str] = Field(None, description="The party specific language to be included in the agreement.")
    """
    The party specific language to be included in the agreement.
    """
    
    @rosetta_condition
    def condition_0_AddendumLanguage(self):
        """
        A data rule to enforce that the French Law Addendum party language must be specified when applicable.
        """
        item = self
        def _then_fn1():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "addendumLanguage")))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "addendumLanguage"))
        
        def _else_fn0():
            return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn1, _else_fn1)
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", True), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
