# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ExposureScopeProductEnum']

class ExposureScopeProductEnum(Enum):
    """
    Description of the relevant derivative transactions excluded from the calculation of exposure.
    """
    CURRENCY_OPTION_TRANSACTIONS = "Currency Option Transactions"
    """
    Currency Option Transactions.
    """
    FX_SETTLEMENT_DATE = "FX Transaction with Settlement Date"
    """
    FX Transactions with Settlement date.
    """
    FX_TRANSACTIONS = "FX Transactions"
    """
    FX Transactions.
    """
