# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExecutionLanguage']


class ExecutionLanguage(BaseDataClass):
    """
    A class to specify execution language terms of a Security Agreement.
    """
    standardLanguage: bool = Field(..., description="A boolean attribute to determine if standard language is applicable or not.")
    """
    A boolean attribute to determine if standard language is applicable or not.
    """
    numberOfOriginals: Optional[str] = Field(None, description="The number of original documents.")
    """
    The number of original documents.
    """
    otherLanguage: Optional[str] = Field(None, description="Bespoke execution language to be included when specified.")
    """
    Bespoke execution language to be included when specified.
    """
    
    @rosetta_condition
    def condition_0_NumberOfOriginals(self):
        """
        A data rule to enforce that the number of original documents should only be specified when standard execution language is used.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "numberOfOriginals")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "standardLanguage"), "=", False), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_OtherLanguage(self):
        """
        A data rule to enforce that bespoke execution language must be included if non-standard execution language is specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "otherLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "standardLanguage"), "=", False), _then_fn0, _else_fn0)

import cdm 
