# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ElectiveAmountElection']


class ElectiveAmountElection(BaseDataClass):
    """
    A class to specify the party elective amounts which can be used for the purpose of specifying elections such as the ISDA CSA Threshold and Minimum Transfer Amount.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    electiveAmount: Optional[cdm.legaldocumentation.csa.ElectiveAmountEnum.ElectiveAmountEnum] = Field(None, description="Specifies an enumerated election to express the elective amount.")
    """
    Specifies an enumerated election to express the elective amount.
    """
    amount: Optional[cdm.observable.asset.Money.Money] = Field(None, description="The elective amount when expressed as a currency amount. The associated PartyElectiveAmount_amount data rule enforces that the currency amount is actually greater than 0.")
    """
    The elective amount when expressed as a currency amount. The associated PartyElectiveAmount_amount data rule enforces that the currency amount is actually greater than 0.
    """
    customElection: Optional[str] = Field(None, description="The elective amount when expressed as a custom election by the party.")
    """
    The elective amount when expressed as a custom election by the party.
    """
    
    @rosetta_condition
    def condition_0_NonZeroAmount(self):
        """
        When the elective amount is not zero either a currency amount or a custom election must exist.
        """
        item = self
        def _then_fn0():
            return (rosetta_attr_exists(rosetta_resolve_attr(self, "amount")) or rosetta_attr_exists(rosetta_resolve_attr(self, "customElection")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "electiveAmount"))), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.legaldocumentation.csa.ElectiveAmountEnum
import cdm.observable.asset.Money
