# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CreditSupportObligationsVariationMargin']


class CreditSupportObligationsVariationMargin(BaseDataClass):
    """
    A class to specify the Credit Support Obligations applicable to the Variation Margin Credit Support Annex.
    """
    ineligibleCreditSupport: Optional[cdm.legaldocumentation.csa.IneligibleCreditSupport.IneligibleCreditSupport] = Field(None, description="The parties to which the provisions of the Credit Support Annex for Variation Margin will apply to.")
    """
    The parties to which the provisions of the Credit Support Annex for Variation Margin will apply to.
    """
    majorCurrency: List[AttributeWithMeta[str] | str] = Field([], description="The additional currencies that are specified as Major Currency for the purpose of applying the FX Haircut Percentage.")
    """
    The additional currencies that are specified as Major Currency for the purpose of applying the FX Haircut Percentage.
    """
    fxHaircut: Optional[str] = Field(None, description="The alternative definition for FX haircut percentage that applies to each party and item of Eligible Collateral unless this item is denominated in a Major Currency or in the Base Currency.")
    """
    The alternative definition for FX haircut percentage that applies to each party and item of Eligible Collateral unless this item is denominated in a Major Currency or in the Base Currency.
    """

import cdm 
import cdm.legaldocumentation.csa.IneligibleCreditSupport
