# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CoveredTransactions']


class CoveredTransactions(BaseDataClass):
    """
    Specification of Transactions covered by the legal agreement.
    """
    inclusionDate: datetime.date = Field(..., description="Includes any Transaction specified below that is entered into on or after the specified date.")
    """
    Includes any Transaction specified below that is entered into on or after the specified date.
    """
    coveredTransactions: List[cdm.base.staticdata.asset.common.ProductTaxonomy.ProductTaxonomy] = Field([], description="Covered Transactions when expressed using the ISDA taxonomy.")
    """
    Covered Transactions when expressed using the ISDA taxonomy.
    """
    @rosetta_condition
    def cardinality_coveredTransactions(self):
        return check_cardinality(self.coveredTransactions, 1, None)
    
    bespokeCoveredTransactions: List[str] = Field([], description="Covered Transactions when not expressed using the ISDA taxonomy.")
    """
    Covered Transactions when not expressed using the ISDA taxonomy.
    """
    @rosetta_condition
    def cardinality_bespokeCoveredTransactions(self):
        return check_cardinality(self.bespokeCoveredTransactions, 1, None)
    
    additionalObligations: List[cdm.legaldocumentation.csa.AdditionalObligations.AdditionalObligations] = Field([], description="The party specific additional obligations applicable to the document.")
    """
    The party specific additional obligations applicable to the document.
    """
    exposure: Optional[str] = Field(None, description="The bespoke definition of exposure for Covered Transactions as part of the agreement.")
    """
    The bespoke definition of exposure for Covered Transactions as part of the agreement.
    """
    legacyExposure: List[cdm.legaldocumentation.csa.ExposureScope.ExposureScope] = Field([], description="Specification of amendments to the calculation of Exposure in terms of the Transactions covered.")
    """
    Specification of amendments to the calculation of Exposure in terms of the Transactions covered.
    """

import cdm 
import cdm.base.staticdata.asset.common.ProductTaxonomy
import cdm.legaldocumentation.csa.AdditionalObligations
import cdm.legaldocumentation.csa.ExposureScope
