# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralRounding']


class CollateralRounding(BaseDataClass):
    """
    A class to specify the rounding methodology applicable to the Delivery Amount and the Return Amount.
    """
    deliveryAmount: Decimal = Field(..., description="The nearest integral multiple of Base Currency units to which the Delivery Amount will be rounded in accordance with the specified rounding direction.")
    """
    The nearest integral multiple of Base Currency units to which the Delivery Amount will be rounded in accordance with the specified rounding direction.
    """
    deliveryDirection: cdm.base.math.RoundingModeEnum.RoundingModeEnum = Field(..., description="The rounding rule applicable to the Delivery Amount (which can be (i) up to nearest; (ii) down to nearest).")
    """
    The rounding rule applicable to the Delivery Amount (which can be (i) up to nearest; (ii) down to nearest).
    """
    returnAmount: Decimal = Field(..., description="The nearest integral multiple of Base Currency units to which the Return Amount will be rounded in accordance with the specified rounding direction.")
    """
    The nearest integral multiple of Base Currency units to which the Return Amount will be rounded in accordance with the specified rounding direction.
    """
    returnDirection: cdm.base.math.RoundingModeEnum.RoundingModeEnum = Field(..., description="The rounding rule applicable to the Return Amount (which can be (i) up to nearest; (ii) down to nearest).")
    """
    The rounding rule applicable to the Return Amount (which can be (i) up to nearest; (ii) down to nearest).
    """
    currency: cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum.ISOCurrencyCodeEnum = Field(..., description="The currency in which the Delivery Amount and Return Amount rounding amounts are specified.")
    """
    The currency in which the Delivery Amount and Return Amount rounding amounts are specified.
    """
    other: Optional[str] = Field(None, description="Utilised where the clause data structure is not able to capture a material aspect of the clause.")
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """

import cdm 
import cdm.base.math.RoundingModeEnum
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum
