# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralAccessBreach']


class CollateralAccessBreach(BaseDataClass):
    """
    A class to specify Collateral Access Breach language.
    """
    isApplicable: bool = Field(..., description="Collateral Access Breach terms are applicable when True and not applicable when False.")
    """
    Collateral Access Breach terms are applicable when True and not applicable when False.
    """
    cabEndDateElection: Optional[bool] = Field(None, description="Determination of whether the Collateral Access Breach end date is a number of days (True) or specified (False).")
    """
    Determination of whether the Collateral Access Breach end date is a number of days (True) or specified (False).
    """
    cabEndDate: Optional[Decimal] = Field(None, description="The business days following the related Collateral Access Breach when the additional terms end.")
    """
    The business days following the related Collateral Access Breach when the additional terms end.
    """
    cabEndDateTerms: Optional[str] = Field(None, description="Specific terms for when Collateral Access Breach terms end.")
    """
    Specific terms for when Collateral Access Breach terms end.
    """
    
    @rosetta_condition
    def condition_0_CabEndDateTerms(self):
        """
        A condition to require Collateral Access Breach End Date Terms when a specification is required.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "cabEndDateTerms")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "cabEndDateElection"), "=", True), _then_fn0, _else_fn0)

import cdm 
