# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CalculationDateLocationElection']


class CalculationDateLocationElection(BaseDataClass):
    """
    A class to specify each of the party elections with respect to the Calculation Date Location.
    """
    party: cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum = Field(..., description="The elective party.")
    """
    The elective party.
    """
    businessCenter: Optional[AttributeWithMeta[cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] | cdm.base.datetime.BusinessCenterEnum.BusinessCenterEnum] = Field(None, description="The Calculation Date Location when specified as a business center which corresponds to the FpML list of business centers or can be mapped to it.")
    """
    The Calculation Date Location when specified as a business center which corresponds to the FpML list of business centers or can be mapped to it.
    """
    customLocation: Optional[str] = Field(None, description="The Calculation Date Location when specified a location which doesn't correspond to the FpML list of business centers or cannot be mapped to it.")
    """
    The Calculation Date Location when specified a location which doesn't correspond to the FpML list of business centers or cannot be mapped to it.
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        """
        The Calculation Date Location is specified either as a standard business center or as a custom location.
        """
        item = self
        return rosetta_check_one_of(self, 'businessCenter', 'customLocation', necessity=True)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.base.datetime.BusinessCenterEnum
