# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CSAMTAVariableSet']


class CSAMTAVariableSet(BaseDataClass):
    """
    Defines a combination of Rating Agency, Rating Value, amount and Currency code.
    """
    name: Optional[cdm.observable.asset.CreditRatingAgencyEnum.CreditRatingAgencyEnum] = Field(None, description="The name of the Rating Agency.")
    """
    The name of the Rating Agency.
    """
    value: Optional[str] = Field(None, description="The value assigned to the rating.")
    """
    The value assigned to the rating.
    """
    amount: Optional[int] = Field(None, description="The Minimum Transfer Amount (MTA) applicable to the Rating.")
    """
    The Minimum Transfer Amount (MTA) applicable to the Rating.
    """
    amountIsInfinity: Optional[bool] = Field(None, description="A flag that defines the Minimum Transfer Amount (MTA) as Infinity.")
    """
    A flag that defines the Minimum Transfer Amount (MTA) as Infinity.
    """
    
    @rosetta_condition
    def condition_0_NameMustExist(self):
        """
        If we have a name then we must also have a value.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "value"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "name")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_ValueMustExist(self):
        """
        If we have a value then we must also have a name.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "name"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "value")), _then_fn0, _else_fn0)

import cdm 
import cdm.observable.asset.CreditRatingAgencyEnum
