# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['BaseAndEligibleCurrency']


class BaseAndEligibleCurrency(BaseDataClass):
    """
    The base and eligible currency(ies) for the document as specified by the parties to the agreement.
    """
    baseCurrency: cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum.ISOCurrencyCodeEnum = Field(..., description="The common agreed currency into which relevant amounts of all collateral arrangements between the parties are converted, or if not an actual currency, the process through which this is determined. Where hardcoded (e.g. under the 1994 ISDA Credit Support Annex (Security Interest NY Law)), the currency that effectively performs this function.")
    """
    The common agreed currency into which relevant amounts of all collateral arrangements between the parties are converted, or if not an actual currency, the process through which this is determined. Where hardcoded (e.g. under the 1994 ISDA Credit Support Annex (Security Interest  NY Law)), the currency that effectively performs this function.
    """
    baseCurrencyTerminationCurrency: bool = Field(..., description="A flag detailing whether the Base Currency is set to the Termination Currency as defined in the related Master Agreement.")
    """
    A flag detailing whether the Base Currency is set to  the Termination Currency as defined in the related  Master Agreement.
    """
    baseCurrencyOther: Optional[AttributeWithMeta[str] | str] = Field(None, description="Utilised where the clause data structure is not able to capture a material aspect of the clause.")
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """
    eligibleCurrency: List[cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum.ISOCurrencyCodeEnum] = Field([], description="A definition of a currency agreed by the parties, typically to indicate the currencies of eligible cash collateral.")
    """
    A definition of a currency agreed by the parties, typically to indicate the currencies of eligible cash collateral.
    """
    eligibleCurrencyInclBaseCurrency: bool = Field(..., description="A flag detailing whether the Base Currency is included as an Eligible Currency.")
    """
    A flag detailing whether the Base Currency is included as an Eligible Currency.
    """
    eligibleCurrencyOther: Optional[AttributeWithMeta[str] | str] = Field(None, description="Utilised where the clause data structure is not able to capture a material aspect of the clause.")
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """

import cdm 
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum
