# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AppropriatedCollateralValuation']


class AppropriatedCollateralValuation(BaseDataClass):
    """
    A class to specify the Valuation of Appropriated Collateral.
    """
    isSpecified: bool = Field(..., description="The qualification of whether the Valuation of Appropriate Collateral provision is applicable (True) or not applicable (False).")
    """
    The qualification of whether the Valuation of Appropriate Collateral provision is applicable (True) or not applicable (False).
    """
    election: Optional[str] = Field(None, description="The parties' election that qualify the Valuation of Appropriate Collateral in the case where it is deemed applicable.")
    """
    The parties' election that qualify the Valuation of Appropriate Collateral in the case where it is deemed applicable.
    """
    
    @rosetta_condition
    def condition_0_Specified(self):
        """
        The Valuation of Appropriate Collateral election must be specified when it is applicable.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "election"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isSpecified"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_NotSpecified(self):
        """
        The Valuation of Appropriate Collateral election cannot be specified when it is not applicable.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "election")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isSpecified"), "=", False), _then_fn0, _else_fn0)

import cdm 
