# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ApplicableRegime']


class ApplicableRegime(BaseDataClass):
    """
    A class to specify the applicable regulatory regime(s) that parties to a legal agreement, such as the ISDA 2016 and 2018 CSA for Initial Margin, might be subject to.
    """
    regime: Optional[cdm.legaldocumentation.csa.RegulatoryRegimeEnum.RegulatoryRegimeEnum] = Field(None, description="The applicable regulatory regime, as specified through an enumeration.")
    """
    The applicable regulatory regime, as specified through an enumeration.
    """
    additionalRegime: Optional[str] = Field(None, description="The additional regulatory regime as specified by the parties.")
    """
    The additional regulatory regime as specified by the parties.
    """
    regimeTerms: List[cdm.legaldocumentation.csa.RegimeTerms.RegimeTerms] = Field([], description="A class that is used by the ApplicableRegime and the AdditionalRegime classes to specify the terms that are specific to each party and regime which are referred to in the Regime Table as part of certain legal agreements, such as the ISDA 2016 and 2018 CSA for Initial Margin.")
    """
    A class that is used by the ApplicableRegime and the AdditionalRegime classes to specify the terms that are specific to each party and regime which are referred to in the Regime Table as part of certain legal agreements, such as the ISDA 2016 and 2018 CSA for Initial Margin.
    """
    @rosetta_condition
    def cardinality_regimeTerms(self):
        return check_cardinality(self.regimeTerms, 2, None)
    
    additionalType: Optional[cdm.legaldocumentation.csa.AdditionalTypeEnum.AdditionalTypeEnum] = Field(None, description="")
    additionalTerms: Optional[str] = Field(None, description="The bespoke Additional Type for the purposes of Covered Transactions (IM).")
    """
    The bespoke Additional Type for the purposes of Covered Transactions (IM).
    """
    
    @rosetta_condition
    def condition_0_ApplicableRegimeChoice(self):
        """
        The applicable regime should be specified either as an enumeration or as an additional regime specified by the parties.
        """
        item = self
        return rosetta_check_one_of(self, 'regime', 'additionalRegime', necessity=True)

import cdm 
import cdm.legaldocumentation.csa.RegulatoryRegimeEnum
import cdm.legaldocumentation.csa.RegimeTerms
import cdm.legaldocumentation.csa.AdditionalTypeEnum
