# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['AmendmentEffectiveDateEnum']

class AmendmentEffectiveDateEnum(Enum):
    """
    The enumerated values to specify the effective date of the Amendment to Termination Currency when specified as a specific date (e.g. the annex date).
    """
    AGREEMENT_DATE = "AgreementDate"
    """
    The effective date corresponds to the Agreement date.
    """
    AMENDMENT_EFFECTIVE_DATE = "AmendmentEffectiveDate"
    """
    The effective date corresponds to the Amendment Effective Date (IM).
    """
    ANNEX_DATE = "AnnexDate"
    """
    The effective date corresponds to the Annex date.
    """
    DEED_DATE = "DeedDate"
    """
    The effective date corresponds to the Deed date.
    """
