# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AdditionalRepresentations']


class AdditionalRepresentations(BaseDataClass):
    """
    A class to specify Additional Representations that may be applicable to an agreement.
    """
    additionalRepresentation: Optional[cdm.legaldocumentation.csa.AdditionalRepresentation.AdditionalRepresentation] = Field(None, description="The specification of the Additional Representation that may be applicable to the agreement.")
    """
    The specification of the Additional Representation that may be applicable to the agreement.
    """
    regulatoryComplianceRepresentation: Optional[bool] = Field(None, description="The qualification of whether Additional Information related to Regulatory Compliance and Concentration Limits is applicable or not.")
    """
    The qualification of whether Additional Information related to Regulatory Compliance and Concentration Limits is applicable or not.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'additionalRepresentation', 'regulatoryComplianceRepresentation', necessity=True)

import cdm 
import cdm.legaldocumentation.csa.AdditionalRepresentation
