# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.event.common.functions.FilterOpenTradeStates import FilterOpenTradeStates
from cdm.event.common.BusinessEvent import BusinessEvent

__all__ = ['Qualify_OnDemandPayment']


@replaceable
def Qualify_OnDemandPayment(businessEvent: BusinessEvent) -> bool:
    """
    Qualification of a on-demand payment.
    
    Parameters 
    ----------
    businessEvent : BusinessEvent
    
    Returns
    -------
    is_event : boolean
    
    """
    self = inspect.currentframe()
    
    
    instruction = get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"))
    afterTradeStates = FilterOpenTradeStates(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after"))
    transfer = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction"), "primitiveInstruction"), "transfer"), "transferState"), "transfer")
    is_event =  ((((all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "instruction")), "=", 1) and all_elements(rosetta_count(rosetta_resolve_attr(rosetta_resolve_attr(self, "businessEvent"), "after")), "=", 1)) and all_elements(rosetta_count(rosetta_resolve_attr(self, "afterTradeStates")), "=", 1)) and rosetta_check_one_of(self, rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instruction"), "primitiveInstruction"), "transfer"))) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "transfer"), "transferExpression"), "scheduledTransfer"), "transferType"), "=", NetInterest))
    
    
    return is_event

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
