/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradableProductForwardPayout_PredeterminedClearingOrganizationParty")
@ImplementedBy(value=Default.class)
public interface TradableProductForwardPayout_PredeterminedClearingOrganizationParty
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductForwardPayout_PredeterminedClearingOrganizationParty";
    public static final String DEFINITION = "if product -> economicTerms -> payout -> SettlementPayout -> settlementTerms -> physicalSettlementTerms -> predeterminedClearingOrganizationParty exists then ancillaryParty -> role contains AncillaryRoleEnum -> PredeterminedClearingOrganizationParty";

    public static class NoOp
    implements TradableProductForwardPayout_PredeterminedClearingOrganizationParty {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradableProductForwardPayout_PredeterminedClearingOrganizationParty {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradableProductForwardPayout_PredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductForwardPayout_PredeterminedClearingOrganizationParty.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradableProductForwardPayout_PredeterminedClearingOrganizationParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductForwardPayout_PredeterminedClearingOrganizationParty.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getSettlementPayout", payout -> payout.getSettlementPayout()).map("getSettlementTerms", settlementPayout -> settlementPayout.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()).map("getPredeterminedClearingOrganizationParty", physicalSettlementTerms -> physicalSettlementTerms.getPredeterminedClearingOrganizationParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.PREDETERMINED_CLEARING_ORGANIZATION_PARTY)));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

