/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradableProductCalculationAgentIndependent")
@ImplementedBy(value=Default.class)
public interface TradableProductCalculationAgentIndependent
extends Validator<TradableProduct> {
    public static final String NAME = "TradableProductCalculationAgentIndependent";
    public static final String DEFINITION = "if product -> economicTerms -> calculationAgent -> calculationAgentParty exists then ancillaryParty -> role contains AncillaryRoleEnum -> CalculationAgentIndependent and if ancillaryParty -> role contains AncillaryRoleEnum -> CalculationAgentIndependent then product -> economicTerms -> calculationAgent -> calculationAgentParty exists";

    public static class NoOp
    implements TradableProductCalculationAgentIndependent {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradableProductCalculationAgentIndependent {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TradableProduct tradableProduct) {
            ComparisonResult result = this.executeDataRule(tradableProduct);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradableProductCalculationAgentIndependent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductCalculationAgentIndependent.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradableProductCalculationAgentIndependent.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TradableProduct", (RosettaPath)path, (String)TradableProductCalculationAgentIndependent.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TradableProduct tradableProduct) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).map("getCalculationAgent", economicTerms -> economicTerms.getCalculationAgent()).map("getCalculationAgentParty", calculationAgent -> calculationAgent.getCalculationAgentParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.CALCULATION_AGENT_INDEPENDENT))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperators.exists((Mapper)MapperS.of((Object)tradableProduct).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).map("getCalculationAgent", economicTerms -> economicTerms.getCalculationAgent()).map("getCalculationAgentParty", calculationAgent -> calculationAgent.getCalculationAgentParty())) : ComparisonResult.successEmptyOperand((String)"");
                    return ExpressionOperators.contains((Mapper)MapperS.of((Object)tradableProduct).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.CALCULATION_AGENT_INDEPENDENT))).and(ifThenElseResult);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

