/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.SettlementPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SettlementPayoutUnderlier")
@ImplementedBy(value=Default.class)
public interface SettlementPayoutUnderlier
extends Validator<SettlementPayout> {
    public static final String NAME = "SettlementPayoutUnderlier";
    public static final String DEFINITION = "underlier -> Product -> NonTransferableProduct is absent";

    public static class NoOp
    implements SettlementPayoutUnderlier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementPayout settlementPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SettlementPayoutUnderlier {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SettlementPayout settlementPayout) {
            ComparisonResult result = this.executeDataRule(settlementPayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SettlementPayoutUnderlier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementPayout", (RosettaPath)path, (String)SettlementPayoutUnderlier.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SettlementPayoutUnderlier.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementPayout", (RosettaPath)path, (String)SettlementPayoutUnderlier.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SettlementPayout settlementPayout) {
            try {
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)settlementPayout).map("getUnderlier", _settlementPayout -> _settlementPayout.getUnderlier()).map("getProduct", underlier -> underlier.getProduct()).map("getNonTransferableProduct", product -> product.getNonTransferableProduct()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

