/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PerformancePayoutQuantity")
@ImplementedBy(value=Default.class)
public interface PerformancePayoutQuantity
extends Validator<PerformancePayout> {
    public static final String NAME = "PerformancePayoutQuantity";
    public static final String DEFINITION = "priceQuantity exists";

    public static class NoOp
    implements PerformancePayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PerformancePayout performancePayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PerformancePayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PerformancePayout performancePayout) {
            ComparisonResult result = this.executeDataRule(performancePayout);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PerformancePayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutQuantity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PerformancePayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutQuantity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PerformancePayout performancePayout) {
            try {
                return ExpressionOperators.exists((Mapper)MapperS.of((Object)performancePayout).map("getPriceQuantity", _performancePayout -> _performancePayout.getPriceQuantity()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

