/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.product.common.settlement.DeliveryMethodEnum;
import cdm.product.template.meta.AssetLegMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AssetLeg", builder=AssetLegBuilderImpl.class, version="6.10.0")
@RuneDataType(value="AssetLeg", model="cdm", builder=AssetLegBuilderImpl.class, version="6.10.0")
public interface AssetLeg
extends RosettaModelObject {
    public static final AssetLegMeta metaData = new AssetLegMeta();

    public AdjustableOrRelativeDate getSettlementDate();

    public DeliveryMethodEnum getDeliveryMethod();

    public AssetLeg build();

    public AssetLegBuilder toBuilder();

    public static AssetLegBuilder builder() {
        return new AssetLegBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetLeg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AssetLeg> getType() {
        return AssetLeg.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.class, this.getSettlementDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryMethod"), DeliveryMethodEnum.class, (Object)this.getDeliveryMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AssetLegBuilderImpl
    implements AssetLegBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder settlementDate;
        protected DeliveryMethodEnum deliveryMethod;

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.settlementDate != null ? this.settlementDate : (this.settlementDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod", isRequired=true)
        @RuneAttribute(value="deliveryMethod", isRequired=true)
        public DeliveryMethodEnum getDeliveryMethod() {
            return this.deliveryMethod;
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AssetLegBuilder setSettlementDate(AdjustableOrRelativeDate _settlementDate) {
            this.settlementDate = _settlementDate == null ? null : _settlementDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod", isRequired=true)
        @RuneAttribute(value="deliveryMethod", isRequired=true)
        public AssetLegBuilder setDeliveryMethod(DeliveryMethodEnum _deliveryMethod) {
            this.deliveryMethod = _deliveryMethod == null ? null : _deliveryMethod;
            return this;
        }

        @Override
        public AssetLeg build() {
            return new AssetLegImpl(this);
        }

        @Override
        public AssetLegBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetLegBuilder prune() {
            if (this.settlementDate != null && !this.settlementDate.prune().hasData()) {
                this.settlementDate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSettlementDate() != null && this.getSettlementDate().hasData()) {
                return true;
            }
            return this.getDeliveryMethod() != null;
        }

        public AssetLegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetLegBuilder o = (AssetLegBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementDate(), (RosettaModelObjectBuilder)o.getSettlementDate(), this::setSettlementDate);
            merger.mergeBasic((Object)this.getDeliveryMethod(), (Object)o.getDeliveryMethod(), this::setDeliveryMethod, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetLeg _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals((Object)this.deliveryMethod, (Object)_that.getDeliveryMethod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryMethod != null ? ((Object)((Object)this.deliveryMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetLegBuilder {settlementDate=" + this.settlementDate + ", deliveryMethod=" + (Object)((Object)this.deliveryMethod) + '}';
        }
    }

    public static interface AssetLegBuilder
    extends AssetLeg,
    RosettaModelObjectBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateSettlementDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getSettlementDate();

        public AssetLegBuilder setSettlementDate(AdjustableOrRelativeDate var1);

        public AssetLegBuilder setDeliveryMethod(DeliveryMethodEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("settlementDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getSettlementDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryMethod"), DeliveryMethodEnum.class, (Object)this.getDeliveryMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AssetLegBuilder prune();
    }

    public static class AssetLegImpl
    implements AssetLeg {
        private final AdjustableOrRelativeDate settlementDate;
        private final DeliveryMethodEnum deliveryMethod;

        protected AssetLegImpl(AssetLegBuilder builder) {
            this.settlementDate = Optional.ofNullable(builder.getSettlementDate()).map(f -> f.build()).orElse(null);
            this.deliveryMethod = builder.getDeliveryMethod();
        }

        @Override
        @RosettaAttribute(value="settlementDate", isRequired=true)
        @RuneAttribute(value="settlementDate", isRequired=true)
        public AdjustableOrRelativeDate getSettlementDate() {
            return this.settlementDate;
        }

        @Override
        @RosettaAttribute(value="deliveryMethod", isRequired=true)
        @RuneAttribute(value="deliveryMethod", isRequired=true)
        public DeliveryMethodEnum getDeliveryMethod() {
            return this.deliveryMethod;
        }

        @Override
        public AssetLeg build() {
            return this;
        }

        @Override
        public AssetLegBuilder toBuilder() {
            AssetLegBuilder builder = AssetLeg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetLegBuilder builder) {
            Optional.ofNullable(this.getSettlementDate()).ifPresent(builder::setSettlementDate);
            Optional.ofNullable(this.getDeliveryMethod()).ifPresent(builder::setDeliveryMethod);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetLeg _that = this.getType().cast(o);
            if (!Objects.equals(this.settlementDate, _that.getSettlementDate())) {
                return false;
            }
            return Objects.equals((Object)this.deliveryMethod, (Object)_that.getDeliveryMethod());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.settlementDate != null ? this.settlementDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryMethod != null ? ((Object)((Object)this.deliveryMethod)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetLeg {settlementDate=" + this.settlementDate + ", deliveryMethod=" + (Object)((Object)this.deliveryMethod) + '}';
        }
    }
}

