/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.product.collateral.AssetMaturity;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=CheckMaturityDefault.class)
public abstract class CheckMaturity
implements RosettaFunction {
    public Boolean evaluate(AssetMaturity maturityRange, EligibilityQuery query) {
        Boolean isEqual = this.doEvaluate(maturityRange, query);
        return isEqual;
    }

    protected abstract Boolean doEvaluate(AssetMaturity var1, EligibilityQuery var2);

    protected abstract MapperS<Boolean> upperBoundCheck(AssetMaturity var1, EligibilityQuery var2);

    protected abstract MapperS<Boolean> lowerBoundCheck(AssetMaturity var1, EligibilityQuery var2);

    public static class CheckMaturityDefault
    extends CheckMaturity {
        @Override
        protected Boolean doEvaluate(AssetMaturity maturityRange, EligibilityQuery query) {
            Boolean isEqual = null;
            return this.assignOutput(isEqual, maturityRange, query);
        }

        protected Boolean assignOutput(Boolean isEqual, AssetMaturity maturityRange, EligibilityQuery query) {
            isEqual = ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange)).or(ComparisonResult.of(this.upperBoundCheck(maturityRange, query)).and(ComparisonResult.of(this.lowerBoundCheck(maturityRange, query)))).get();
            return isEqual;
        }

        @Override
        protected MapperS<Boolean> upperBoundCheck(AssetMaturity maturityRange, EligibilityQuery query) {
            if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)true);
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getInclusive", periodBound -> periodBound.getInclusive())).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getInclusive", periodBound -> periodBound.getInclusive()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer0 -> integer0 == null ? null : BigDecimal.valueOf(integer0.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }
            return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer1 -> integer1 == null ? null : BigDecimal.valueOf(integer1.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperS<Boolean> lowerBoundCheck(AssetMaturity maturityRange, EligibilityQuery query) {
            if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)true);
            }
            if (ComparisonResult.of((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getInclusive", periodBound -> periodBound.getInclusive())).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getInclusive", periodBound -> periodBound.getInclusive()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer0 -> integer0 == null ? null : BigDecimal.valueOf(integer0.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
            }
            return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)maturityRange).map("getMaturityRange", assetMaturity -> assetMaturity.getMaturityRange()).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).map("Type coercion", integer1 -> integer1 == null ? null : BigDecimal.valueOf(integer1.intValue())), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }
    }
}

