/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.base.math.Rounding;
import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ApplyFinalRateRoundingDefault.class)
public abstract class ApplyFinalRateRounding
implements RosettaFunction {
    @Inject
    protected RoundToPrecision roundToPrecision;

    public BigDecimal evaluate(BigDecimal baseRate, Rounding finalRateRounding) {
        BigDecimal roundedRate = this.doEvaluate(baseRate, finalRateRounding);
        return roundedRate;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, Rounding var2);

    protected abstract MapperS<Integer> precision(BigDecimal var1, Rounding var2);

    protected abstract MapperS<RoundingDirectionEnum> direction(BigDecimal var1, Rounding var2);

    public static class ApplyFinalRateRoundingDefault
    extends ApplyFinalRateRounding {
        @Override
        protected BigDecimal doEvaluate(BigDecimal baseRate, Rounding finalRateRounding) {
            BigDecimal roundedRate = null;
            return this.assignOutput(roundedRate, baseRate, finalRateRounding);
        }

        protected BigDecimal assignOutput(BigDecimal roundedRate, BigDecimal baseRate, Rounding finalRateRounding) {
            roundedRate = this.roundToPrecision.evaluate(baseRate, (Integer)this.precision(baseRate, finalRateRounding).get(), (RoundingDirectionEnum)((Object)this.direction(baseRate, finalRateRounding).get()), false);
            return roundedRate;
        }

        @Override
        protected MapperS<Integer> precision(BigDecimal baseRate, Rounding finalRateRounding) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)finalRateRounding).map("getPrecision", rounding -> rounding.getPrecision())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)finalRateRounding).map("getPrecision", rounding -> rounding.getPrecision());
            }
            return MapperS.of((Object)7);
        }

        @Override
        protected MapperS<RoundingDirectionEnum> direction(BigDecimal baseRate, Rounding finalRateRounding) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)finalRateRounding).map("getRoundingDirection", rounding -> rounding.getRoundingDirection())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)finalRateRounding).map("getRoundingDirection", rounding -> rounding.getRoundingDirection());
            }
            return MapperS.of((Object)((Object)RoundingDirectionEnum.NEAREST));
        }
    }
}

