/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.calculation.functions;

import cdm.base.datetime.daycount.metafields.FieldWithMetaDayCountFractionEnum;
import cdm.observable.asset.Money;
import cdm.product.asset.FixedAmountCalculationDetails;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.calculation.functions.CalculateYearFraction;
import cdm.product.asset.calculation.functions.GetFixedRate;
import cdm.product.asset.calculation.functions.GetNotionalAmount;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FixedAmountCalculationDefault.class)
public abstract class FixedAmountCalculation
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CalculateYearFraction calculateYearFraction;
    @Inject
    protected GetFixedRate getFixedRate;
    @Inject
    protected GetNotionalAmount getNotionalAmount;

    public FixedAmountCalculationDetails evaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
        FixedAmountCalculationDetails fixedAmountDetails;
        FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder fixedAmountDetailsBuilder = this.doEvaluate(interestRatePayout, calculationPeriod, notional);
        if (fixedAmountDetailsBuilder == null) {
            fixedAmountDetails = null;
        } else {
            fixedAmountDetails = fixedAmountDetailsBuilder.build();
            this.objectValidator.validate(FixedAmountCalculationDetails.class, (RosettaModelObject)fixedAmountDetails);
        }
        return fixedAmountDetails;
    }

    protected abstract FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> fixedRate(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract MapperS<? extends Money> calculationAmount(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract MapperS<? extends FieldWithMetaDayCountFractionEnum> dcf(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> yearFraction(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    protected abstract MapperS<BigDecimal> calcAmt(InterestRatePayout var1, CalculationPeriodBase var2, BigDecimal var3);

    public static class FixedAmountCalculationDefault
    extends FixedAmountCalculation {
        @Override
        protected FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder doEvaluate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder fixedAmountDetails = FixedAmountCalculationDetails.builder();
            return this.assignOutput(fixedAmountDetails, interestRatePayout, calculationPeriod, notional);
        }

        protected FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder assignOutput(FixedAmountCalculationDetails.FixedAmountCalculationDetailsBuilder fixedAmountDetails, InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            fixedAmountDetails.setCalculationPeriod(calculationPeriod);
            fixedAmountDetails.getOrCreateCalculationPeriodNotionalAmount().setValue((BigDecimal)this.calcAmt(interestRatePayout, calculationPeriod, notional).get());
            fixedAmountDetails.getOrCreateCalculationPeriodNotionalAmount().getOrCreateUnit().setCurrency((FieldWithMetaString)this.calculationAmount(interestRatePayout, calculationPeriod, notional).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get());
            fixedAmountDetails.setFixedRate((BigDecimal)this.fixedRate(interestRatePayout, calculationPeriod, notional).get());
            fixedAmountDetails.setYearFraction((BigDecimal)this.yearFraction(interestRatePayout, calculationPeriod, notional).get());
            fixedAmountDetails.setCalculatedAmount((BigDecimal)MapperMaths.multiply((Mapper)MapperMaths.multiply(this.calcAmt(interestRatePayout, calculationPeriod, notional), (Mapper)MapperS.of((Object)fixedAmountDetails).map("getFixedRate", fixedAmountCalculationDetails -> fixedAmountCalculationDetails.getFixedRate())), (Mapper)MapperS.of((Object)fixedAmountDetails).map("getYearFraction", fixedAmountCalculationDetails -> fixedAmountCalculationDetails.getYearFraction())).get());
            return Optional.ofNullable(fixedAmountDetails).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<BigDecimal> fixedRate(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)this.getFixedRate.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<? extends Money> calculationAmount(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)this.getNotionalAmount.evaluate(interestRatePayout, calculationPeriod));
        }

        @Override
        protected MapperS<? extends FieldWithMetaDayCountFractionEnum> dcf(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            return MapperS.of((Object)interestRatePayout).map("getDayCountFraction", _interestRatePayout -> _interestRatePayout.getDayCountFraction());
        }

        @Override
        protected MapperS<BigDecimal> yearFraction(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            FieldWithMetaDayCountFractionEnum fieldWithMetaDayCountFractionEnum = (FieldWithMetaDayCountFractionEnum)this.dcf(interestRatePayout, calculationPeriod, notional).get();
            return MapperS.of((Object)this.calculateYearFraction.evaluate(interestRatePayout, fieldWithMetaDayCountFractionEnum == null ? null : fieldWithMetaDayCountFractionEnum.getValue(), calculationPeriod));
        }

        @Override
        protected MapperS<BigDecimal> calcAmt(InterestRatePayout interestRatePayout, CalculationPeriodBase calculationPeriod, BigDecimal notional) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)notional)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)notional);
            }
            return this.calculationAmount(interestRatePayout, calculationPeriod, notional).map("getValue", money -> money.getValue());
        }
    }
}

