/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.Money;
import cdm.product.asset.StubFloatingRate;
import cdm.product.asset.meta.StubValueMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="StubValue", builder=StubValueBuilderImpl.class, version="6.10.0")
@RuneDataType(value="StubValue", model="cdm", builder=StubValueBuilderImpl.class, version="6.10.0")
public interface StubValue
extends RosettaModelObject {
    public static final StubValueMeta metaData = new StubValueMeta();

    public List<? extends StubFloatingRate> getFloatingRate();

    public BigDecimal getStubRate();

    public Money getStubAmount();

    public StubValue build();

    public StubValueBuilder toBuilder();

    public static StubValueBuilder builder() {
        return new StubValueBuilderImpl();
    }

    default public RosettaMetaData<? extends StubValue> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StubValue> getType() {
        return StubValue.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("floatingRate"), processor, StubFloatingRate.class, this.getFloatingRate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("stubRate"), BigDecimal.class, (Object)this.getStubRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("stubAmount"), processor, Money.class, this.getStubAmount(), new AttributeMeta[0]);
    }

    public static class StubValueBuilderImpl
    implements StubValueBuilder {
        protected List<StubFloatingRate.StubFloatingRateBuilder> floatingRate = new ArrayList<StubFloatingRate.StubFloatingRateBuilder>();
        protected BigDecimal stubRate;
        protected Money.MoneyBuilder stubAmount;

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public List<? extends StubFloatingRate.StubFloatingRateBuilder> getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        public StubFloatingRate.StubFloatingRateBuilder getOrCreateFloatingRate(int index) {
            if (this.floatingRate == null) {
                this.floatingRate = new ArrayList<StubFloatingRate.StubFloatingRateBuilder>();
            }
            return (StubFloatingRate.StubFloatingRateBuilder)this.getIndex(this.floatingRate, index, () -> {
                StubFloatingRate.StubFloatingRateBuilder newFloatingRate = StubFloatingRate.builder();
                return newFloatingRate;
            });
        }

        @Override
        @RosettaAttribute(value="stubRate")
        @RuneAttribute(value="stubRate")
        public BigDecimal getStubRate() {
            return this.stubRate;
        }

        @Override
        @RosettaAttribute(value="stubAmount")
        @RuneAttribute(value="stubAmount")
        public Money.MoneyBuilder getStubAmount() {
            return this.stubAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreateStubAmount() {
            Money.MoneyBuilder result = this.stubAmount != null ? this.stubAmount : (this.stubAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public StubValueBuilder addFloatingRate(StubFloatingRate _floatingRate) {
            if (_floatingRate != null) {
                this.floatingRate.add(_floatingRate.toBuilder());
            }
            return this;
        }

        @Override
        public StubValueBuilder addFloatingRate(StubFloatingRate _floatingRate, int idx) {
            this.getIndex(this.floatingRate, idx, () -> _floatingRate.toBuilder());
            return this;
        }

        @Override
        public StubValueBuilder addFloatingRate(List<? extends StubFloatingRate> floatingRates) {
            if (floatingRates != null) {
                for (StubFloatingRate stubFloatingRate : floatingRates) {
                    this.floatingRate.add(stubFloatingRate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="floatingRate")
        public StubValueBuilder setFloatingRate(List<? extends StubFloatingRate> floatingRates) {
            this.floatingRate = floatingRates == null ? new ArrayList<StubFloatingRate.StubFloatingRateBuilder>() : (List)floatingRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="stubRate")
        @RuneAttribute(value="stubRate")
        public StubValueBuilder setStubRate(BigDecimal _stubRate) {
            this.stubRate = _stubRate == null ? null : _stubRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="stubAmount")
        @RuneAttribute(value="stubAmount")
        public StubValueBuilder setStubAmount(Money _stubAmount) {
            this.stubAmount = _stubAmount == null ? null : _stubAmount.toBuilder();
            return this;
        }

        @Override
        public StubValue build() {
            return new StubValueImpl(this);
        }

        @Override
        public StubValueBuilder toBuilder() {
            return this;
        }

        @Override
        public StubValueBuilder prune() {
            this.floatingRate = this.floatingRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.stubAmount != null && !this.stubAmount.prune().hasData()) {
                this.stubAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getFloatingRate() != null && this.getFloatingRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getStubRate() != null) {
                return true;
            }
            return this.getStubAmount() != null && this.getStubAmount().hasData();
        }

        public StubValueBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StubValueBuilder o = (StubValueBuilder)other;
            merger.mergeRosetta(this.getFloatingRate(), o.getFloatingRate(), this::getOrCreateFloatingRate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStubAmount(), (RosettaModelObjectBuilder)o.getStubAmount(), this::setStubAmount);
            merger.mergeBasic((Object)this.getStubRate(), (Object)o.getStubRate(), this::setStubRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StubValue _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.stubRate, _that.getStubRate())) {
                return false;
            }
            return Objects.equals(this.stubAmount, _that.getStubAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.stubRate != null ? this.stubRate.hashCode() : 0);
            _result = 31 * _result + (this.stubAmount != null ? this.stubAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StubValueBuilder {floatingRate=" + this.floatingRate + ", stubRate=" + this.stubRate + ", stubAmount=" + this.stubAmount + '}';
        }
    }

    public static interface StubValueBuilder
    extends StubValue,
    RosettaModelObjectBuilder {
        public StubFloatingRate.StubFloatingRateBuilder getOrCreateFloatingRate(int var1);

        public List<? extends StubFloatingRate.StubFloatingRateBuilder> getFloatingRate();

        public Money.MoneyBuilder getOrCreateStubAmount();

        @Override
        public Money.MoneyBuilder getStubAmount();

        public StubValueBuilder addFloatingRate(StubFloatingRate var1);

        public StubValueBuilder addFloatingRate(StubFloatingRate var1, int var2);

        public StubValueBuilder addFloatingRate(List<? extends StubFloatingRate> var1);

        public StubValueBuilder setFloatingRate(List<? extends StubFloatingRate> var1);

        public StubValueBuilder setStubRate(BigDecimal var1);

        public StubValueBuilder setStubAmount(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("floatingRate"), processor, StubFloatingRate.StubFloatingRateBuilder.class, this.getFloatingRate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("stubRate"), BigDecimal.class, (Object)this.getStubRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("stubAmount"), processor, Money.MoneyBuilder.class, this.getStubAmount(), new AttributeMeta[0]);
        }

        public StubValueBuilder prune();
    }

    public static class StubValueImpl
    implements StubValue {
        private final List<? extends StubFloatingRate> floatingRate;
        private final BigDecimal stubRate;
        private final Money stubAmount;

        protected StubValueImpl(StubValueBuilder builder) {
            this.floatingRate = Optional.ofNullable(builder.getFloatingRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.stubRate = builder.getStubRate();
            this.stubAmount = Optional.ofNullable(builder.getStubAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="floatingRate")
        @RuneAttribute(value="floatingRate")
        public List<? extends StubFloatingRate> getFloatingRate() {
            return this.floatingRate;
        }

        @Override
        @RosettaAttribute(value="stubRate")
        @RuneAttribute(value="stubRate")
        public BigDecimal getStubRate() {
            return this.stubRate;
        }

        @Override
        @RosettaAttribute(value="stubAmount")
        @RuneAttribute(value="stubAmount")
        public Money getStubAmount() {
            return this.stubAmount;
        }

        @Override
        public StubValue build() {
            return this;
        }

        @Override
        public StubValueBuilder toBuilder() {
            StubValueBuilder builder = StubValue.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StubValueBuilder builder) {
            Optional.ofNullable(this.getFloatingRate()).ifPresent(builder::setFloatingRate);
            Optional.ofNullable(this.getStubRate()).ifPresent(builder::setStubRate);
            Optional.ofNullable(this.getStubAmount()).ifPresent(builder::setStubAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StubValue _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.floatingRate, _that.getFloatingRate())) {
                return false;
            }
            if (!Objects.equals(this.stubRate, _that.getStubRate())) {
                return false;
            }
            return Objects.equals(this.stubAmount, _that.getStubAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.floatingRate != null ? this.floatingRate.hashCode() : 0);
            _result = 31 * _result + (this.stubRate != null ? this.stubRate.hashCode() : 0);
            _result = 31 * _result + (this.stubAmount != null ? this.stubAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StubValue {floatingRate=" + this.floatingRate + ", stubRate=" + this.stubRate + ", stubAmount=" + this.stubAmount + '}';
        }
    }
}

