/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PriceQuantityNonCurrencyQuantities")
@ImplementedBy(value=Default.class)
public interface PriceQuantityNonCurrencyQuantities
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityNonCurrencyQuantities";
    public static final String DEFINITION = "(quantity count - quantity -> unit -> currency count) <= 1 or (observable -> Asset -> Commodity exists and quantity -> unit -> capacityUnit exists and (quantity count - quantity -> unit -> currency count) <= 2)";

    public static class NoOp
    implements PriceQuantityNonCurrencyQuantities {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PriceQuantityNonCurrencyQuantities {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PriceQuantityNonCurrencyQuantities.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityNonCurrencyQuantities.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PriceQuantityNonCurrencyQuantities.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityNonCurrencyQuantities.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                return ExpressionOperators.lessThanEquals((Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).resultCount())), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()).map("Type coercion", fieldWithMetaObservable -> fieldWithMetaObservable == null ? null : fieldWithMetaObservable.getValue()).map("getAsset", observable -> observable.getAsset()).map("getCommodity", asset -> asset.getCommodity())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCapacityUnit", unitType -> unitType.getCapacityUnit()))).and(ExpressionOperators.lessThanEquals((Mapper)MapperMaths.subtract((Mapper)MapperS.of((Object)MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).resultCount()), (Mapper)MapperS.of((Object)MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).resultCount())), (Mapper)MapperS.of((Object)2), (CardinalityOperator)CardinalityOperator.All)));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

