/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.CashPrice;
import cdm.observable.asset.CashPriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CashPricePremiumType")
@ImplementedBy(value=Default.class)
public interface CashPricePremiumType
extends Validator<CashPrice> {
    public static final String NAME = "CashPricePremiumType";
    public static final String DEFINITION = "if premiumExpression exists then cashPriceType = CashPriceTypeEnum -> Premium";

    public static class NoOp
    implements CashPricePremiumType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CashPrice cashPrice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CashPricePremiumType {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CashPrice cashPrice) {
            ComparisonResult result = this.executeDataRule(cashPrice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CashPricePremiumType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CashPrice", (RosettaPath)path, (String)CashPricePremiumType.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CashPricePremiumType.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CashPrice", (RosettaPath)path, (String)CashPricePremiumType.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CashPrice cashPrice) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)cashPrice).map("getPremiumExpression", _cashPrice -> _cashPrice.getPremiumExpression())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)cashPrice).map("getCashPriceType", _cashPrice -> _cashPrice.getCashPriceType()), (Mapper)MapperS.of((Object)((Object)CashPriceTypeEnum.PREMIUM)), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

