/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="FeeTypeEnum")
public enum FeeTypeEnum {
    ASSIGNMENT("Assignment", null),
    BROKERAGE_COMMISSION("BrokerageCommission", null),
    INCREASE("Increase", null),
    NOVATION("Novation", null),
    PARTIAL_TERMINATION("PartialTermination", null),
    PREMIUM("Premium", null),
    RENEGOTIATION("Renegotiation", null),
    TERMINATION("Termination", null),
    UPFRONT("Upfront", null),
    CREDIT_EVENT("CreditEvent", null),
    CORPORATE_ACTION("CorporateAction", null);

    private static Map<String, FeeTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private FeeTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static FeeTypeEnum fromDisplayName(String name) {
        FeeTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, FeeTypeEnum> map = new ConcurrentHashMap<String, FeeTypeEnum>();
        for (FeeTypeEnum instance : FeeTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

