/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule.functions;

import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=StandardizedScheduleOptionNotionalAmountDefault.class)
public abstract class StandardizedScheduleOptionNotionalAmount
implements RosettaFunction {
    public BigDecimal evaluate(OptionPayout optionPayout) {
        BigDecimal amount = this.doEvaluate(optionPayout);
        return amount;
    }

    protected abstract BigDecimal doEvaluate(OptionPayout var1);

    protected abstract MapperS<BigDecimal> strikePrice(OptionPayout var1);

    protected abstract MapperS<BigDecimal> notionalQuantity(OptionPayout var1);

    public static class StandardizedScheduleOptionNotionalAmountDefault
    extends StandardizedScheduleOptionNotionalAmount {
        @Override
        protected BigDecimal doEvaluate(OptionPayout optionPayout) {
            BigDecimal amount = null;
            return this.assignOutput(amount, optionPayout);
        }

        protected BigDecimal assignOutput(BigDecimal amount, OptionPayout optionPayout) {
            amount = (BigDecimal)MapperMaths.multiply(this.strikePrice(optionPayout), this.notionalQuantity(optionPayout)).get();
            return amount;
        }

        @Override
        protected MapperS<BigDecimal> strikePrice(OptionPayout optionPayout) {
            return MapperS.of((Object)optionPayout).map("getStrike", _optionPayout -> _optionPayout.getStrike()).map("getStrikePrice", optionStrike -> optionStrike.getStrikePrice()).map("getValue", price -> price.getValue());
        }

        @Override
        protected MapperS<BigDecimal> notionalQuantity(OptionPayout optionPayout) {
            MapperS thenArg = MapperS.of((Object)optionPayout).map("getPriceQuantity", _optionPayout -> _optionPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            MapperS ifThenElseResult = ExpressionOperators.exists((Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier())).getOrDefault(Boolean.valueOf(false)) != false ? MapperMaths.multiply((Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()), (Mapper)thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule2 -> referenceWithMetaNonNegativeQuantitySchedule2 == null ? null : referenceWithMetaNonNegativeQuantitySchedule2.getValue()).map("getMultiplier", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getMultiplier()).map("getValue", measure -> measure.getValue())) : thenArg.map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule3 -> referenceWithMetaNonNegativeQuantitySchedule3 == null ? null : referenceWithMetaNonNegativeQuantitySchedule3.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
            return ifThenElseResult;
        }
    }
}

