/*
 * Decompiled with CFR 0.152.
 */
package cdm.margin.schedule;

import cdm.margin.schedule.StandardizedScheduleAssetClassEnum;
import cdm.margin.schedule.StandardizedScheduleProductClassEnum;
import cdm.margin.schedule.meta.StandardizedScheduleTradeInfoMeta;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="StandardizedScheduleTradeInfo", builder=StandardizedScheduleTradeInfoBuilderImpl.class, version="6.10.0")
@RuneDataType(value="StandardizedScheduleTradeInfo", model="cdm", builder=StandardizedScheduleTradeInfoBuilderImpl.class, version="6.10.0")
public interface StandardizedScheduleTradeInfo
extends RosettaModelObject {
    public static final StandardizedScheduleTradeInfoMeta metaData = new StandardizedScheduleTradeInfoMeta();

    public StandardizedScheduleAssetClassEnum getAssetClass();

    public StandardizedScheduleProductClassEnum getProductClass();

    public Money getGrossInitialMargin();

    public Money getMarkToMarketValue();

    public StandardizedScheduleTradeInfo build();

    public StandardizedScheduleTradeInfoBuilder toBuilder();

    public static StandardizedScheduleTradeInfoBuilder builder() {
        return new StandardizedScheduleTradeInfoBuilderImpl();
    }

    default public RosettaMetaData<? extends StandardizedScheduleTradeInfo> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends StandardizedScheduleTradeInfo> getType() {
        return StandardizedScheduleTradeInfo.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("assetClass"), StandardizedScheduleAssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productClass"), StandardizedScheduleProductClassEnum.class, (Object)this.getProductClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("grossInitialMargin"), processor, Money.class, this.getGrossInitialMargin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("markToMarketValue"), processor, Money.class, this.getMarkToMarketValue(), new AttributeMeta[0]);
    }

    public static class StandardizedScheduleTradeInfoBuilderImpl
    implements StandardizedScheduleTradeInfoBuilder {
        protected StandardizedScheduleAssetClassEnum assetClass;
        protected StandardizedScheduleProductClassEnum productClass;
        protected Money.MoneyBuilder grossInitialMargin;
        protected Money.MoneyBuilder markToMarketValue;

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public StandardizedScheduleAssetClassEnum getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="productClass")
        @RuneAttribute(value="productClass")
        public StandardizedScheduleProductClassEnum getProductClass() {
            return this.productClass;
        }

        @Override
        @RosettaAttribute(value="grossInitialMargin")
        @RuneAttribute(value="grossInitialMargin")
        public Money.MoneyBuilder getGrossInitialMargin() {
            return this.grossInitialMargin;
        }

        @Override
        public Money.MoneyBuilder getOrCreateGrossInitialMargin() {
            Money.MoneyBuilder result = this.grossInitialMargin != null ? this.grossInitialMargin : (this.grossInitialMargin = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="markToMarketValue")
        @RuneAttribute(value="markToMarketValue")
        public Money.MoneyBuilder getMarkToMarketValue() {
            return this.markToMarketValue;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMarkToMarketValue() {
            Money.MoneyBuilder result = this.markToMarketValue != null ? this.markToMarketValue : (this.markToMarketValue = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public StandardizedScheduleTradeInfoBuilder setAssetClass(StandardizedScheduleAssetClassEnum _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="productClass")
        @RuneAttribute(value="productClass")
        public StandardizedScheduleTradeInfoBuilder setProductClass(StandardizedScheduleProductClassEnum _productClass) {
            this.productClass = _productClass == null ? null : _productClass;
            return this;
        }

        @Override
        @RosettaAttribute(value="grossInitialMargin")
        @RuneAttribute(value="grossInitialMargin")
        public StandardizedScheduleTradeInfoBuilder setGrossInitialMargin(Money _grossInitialMargin) {
            this.grossInitialMargin = _grossInitialMargin == null ? null : _grossInitialMargin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="markToMarketValue")
        @RuneAttribute(value="markToMarketValue")
        public StandardizedScheduleTradeInfoBuilder setMarkToMarketValue(Money _markToMarketValue) {
            this.markToMarketValue = _markToMarketValue == null ? null : _markToMarketValue.toBuilder();
            return this;
        }

        @Override
        public StandardizedScheduleTradeInfo build() {
            return new StandardizedScheduleTradeInfoImpl(this);
        }

        @Override
        public StandardizedScheduleTradeInfoBuilder toBuilder() {
            return this;
        }

        @Override
        public StandardizedScheduleTradeInfoBuilder prune() {
            if (this.grossInitialMargin != null && !this.grossInitialMargin.prune().hasData()) {
                this.grossInitialMargin = null;
            }
            if (this.markToMarketValue != null && !this.markToMarketValue.prune().hasData()) {
                this.markToMarketValue = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getProductClass() != null) {
                return true;
            }
            if (this.getGrossInitialMargin() != null && this.getGrossInitialMargin().hasData()) {
                return true;
            }
            return this.getMarkToMarketValue() != null && this.getMarkToMarketValue().hasData();
        }

        public StandardizedScheduleTradeInfoBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            StandardizedScheduleTradeInfoBuilder o = (StandardizedScheduleTradeInfoBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGrossInitialMargin(), (RosettaModelObjectBuilder)o.getGrossInitialMargin(), this::setGrossInitialMargin);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarkToMarketValue(), (RosettaModelObjectBuilder)o.getMarkToMarketValue(), this::setMarkToMarketValue);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getProductClass(), (Object)o.getProductClass(), this::setProductClass, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StandardizedScheduleTradeInfo _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.productClass, (Object)_that.getProductClass())) {
                return false;
            }
            if (!Objects.equals(this.grossInitialMargin, _that.getGrossInitialMargin())) {
                return false;
            }
            return Objects.equals(this.markToMarketValue, _that.getMarkToMarketValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.productClass != null ? ((Object)((Object)this.productClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.grossInitialMargin != null ? this.grossInitialMargin.hashCode() : 0);
            _result = 31 * _result + (this.markToMarketValue != null ? this.markToMarketValue.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StandardizedScheduleTradeInfoBuilder {assetClass=" + (Object)((Object)this.assetClass) + ", productClass=" + (Object)((Object)this.productClass) + ", grossInitialMargin=" + this.grossInitialMargin + ", markToMarketValue=" + this.markToMarketValue + '}';
        }
    }

    public static interface StandardizedScheduleTradeInfoBuilder
    extends StandardizedScheduleTradeInfo,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateGrossInitialMargin();

        @Override
        public Money.MoneyBuilder getGrossInitialMargin();

        public Money.MoneyBuilder getOrCreateMarkToMarketValue();

        @Override
        public Money.MoneyBuilder getMarkToMarketValue();

        public StandardizedScheduleTradeInfoBuilder setAssetClass(StandardizedScheduleAssetClassEnum var1);

        public StandardizedScheduleTradeInfoBuilder setProductClass(StandardizedScheduleProductClassEnum var1);

        public StandardizedScheduleTradeInfoBuilder setGrossInitialMargin(Money var1);

        public StandardizedScheduleTradeInfoBuilder setMarkToMarketValue(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("assetClass"), StandardizedScheduleAssetClassEnum.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productClass"), StandardizedScheduleProductClassEnum.class, (Object)this.getProductClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("grossInitialMargin"), processor, Money.MoneyBuilder.class, this.getGrossInitialMargin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("markToMarketValue"), processor, Money.MoneyBuilder.class, this.getMarkToMarketValue(), new AttributeMeta[0]);
        }

        public StandardizedScheduleTradeInfoBuilder prune();
    }

    public static class StandardizedScheduleTradeInfoImpl
    implements StandardizedScheduleTradeInfo {
        private final StandardizedScheduleAssetClassEnum assetClass;
        private final StandardizedScheduleProductClassEnum productClass;
        private final Money grossInitialMargin;
        private final Money markToMarketValue;

        protected StandardizedScheduleTradeInfoImpl(StandardizedScheduleTradeInfoBuilder builder) {
            this.assetClass = builder.getAssetClass();
            this.productClass = builder.getProductClass();
            this.grossInitialMargin = Optional.ofNullable(builder.getGrossInitialMargin()).map(f -> f.build()).orElse(null);
            this.markToMarketValue = Optional.ofNullable(builder.getMarkToMarketValue()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public StandardizedScheduleAssetClassEnum getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="productClass")
        @RuneAttribute(value="productClass")
        public StandardizedScheduleProductClassEnum getProductClass() {
            return this.productClass;
        }

        @Override
        @RosettaAttribute(value="grossInitialMargin")
        @RuneAttribute(value="grossInitialMargin")
        public Money getGrossInitialMargin() {
            return this.grossInitialMargin;
        }

        @Override
        @RosettaAttribute(value="markToMarketValue")
        @RuneAttribute(value="markToMarketValue")
        public Money getMarkToMarketValue() {
            return this.markToMarketValue;
        }

        @Override
        public StandardizedScheduleTradeInfo build() {
            return this;
        }

        @Override
        public StandardizedScheduleTradeInfoBuilder toBuilder() {
            StandardizedScheduleTradeInfoBuilder builder = StandardizedScheduleTradeInfo.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(StandardizedScheduleTradeInfoBuilder builder) {
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
            Optional.ofNullable(this.getProductClass()).ifPresent(builder::setProductClass);
            Optional.ofNullable(this.getGrossInitialMargin()).ifPresent(builder::setGrossInitialMargin);
            Optional.ofNullable(this.getMarkToMarketValue()).ifPresent(builder::setMarkToMarketValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            StandardizedScheduleTradeInfo _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.productClass, (Object)_that.getProductClass())) {
                return false;
            }
            if (!Objects.equals(this.grossInitialMargin, _that.getGrossInitialMargin())) {
                return false;
            }
            return Objects.equals(this.markToMarketValue, _that.getMarkToMarketValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.productClass != null ? ((Object)((Object)this.productClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.grossInitialMargin != null ? this.grossInitialMargin.hashCode() : 0);
            _result = 31 * _result + (this.markToMarketValue != null ? this.markToMarketValue.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "StandardizedScheduleTradeInfo {assetClass=" + (Object)((Object)this.assetClass) + ", productClass=" + (Object)((Object)this.productClass) + ", grossInitialMargin=" + this.grossInitialMargin + ", markToMarketValue=" + this.markToMarketValue + '}';
        }
    }
}

