/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.SecuredPartyRightsEvent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="SecuredPartyRightsEventFailureToPayLanguage")
@ImplementedBy(value=Default.class)
public interface SecuredPartyRightsEventFailureToPayLanguage
extends Validator<SecuredPartyRightsEvent> {
    public static final String NAME = "SecuredPartyRightsEventFailureToPayLanguage";
    public static final String DEFINITION = "if earlyTerminationDateOptionalLanguage = False then failureToPayEarlyTermination is absent";

    public static class NoOp
    implements SecuredPartyRightsEventFailureToPayLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SecuredPartyRightsEvent securedPartyRightsEvent) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements SecuredPartyRightsEventFailureToPayLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, SecuredPartyRightsEvent securedPartyRightsEvent) {
            ComparisonResult result = this.executeDataRule(securedPartyRightsEvent);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)SecuredPartyRightsEventFailureToPayLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SecuredPartyRightsEvent", (RosettaPath)path, (String)SecuredPartyRightsEventFailureToPayLanguage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)SecuredPartyRightsEventFailureToPayLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SecuredPartyRightsEvent", (RosettaPath)path, (String)SecuredPartyRightsEventFailureToPayLanguage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(SecuredPartyRightsEvent securedPartyRightsEvent) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)securedPartyRightsEvent).map("getEarlyTerminationDateOptionalLanguage", _securedPartyRightsEvent -> _securedPartyRightsEvent.getEarlyTerminationDateOptionalLanguage()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.notExists((Mapper)MapperS.of((Object)securedPartyRightsEvent).map("getFailureToPayEarlyTermination", _securedPartyRightsEvent -> _securedPartyRightsEvent.getFailureToPayEarlyTermination()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

