/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.LegacyResolutionValue;
import cdm.legaldocumentation.csa.ValueCashEnum;
import cdm.legaldocumentation.csa.ValueSecuritiesEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegacyResolutionValueOtherValues")
@ImplementedBy(value=Default.class)
public interface LegacyResolutionValueOtherValues
extends Validator<LegacyResolutionValue> {
    public static final String NAME = "LegacyResolutionValueOtherValues";
    public static final String DEFINITION = "if cash = ValueCashEnum -> Other or securities = ValueSecuritiesEnum -> Other then additionalLanguage exists";

    public static class NoOp
    implements LegacyResolutionValueOtherValues {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegacyResolutionValue legacyResolutionValue) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegacyResolutionValueOtherValues {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegacyResolutionValue legacyResolutionValue) {
            ComparisonResult result = this.executeDataRule(legacyResolutionValue);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegacyResolutionValueOtherValues.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegacyResolutionValue", (RosettaPath)path, (String)LegacyResolutionValueOtherValues.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegacyResolutionValueOtherValues.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegacyResolutionValue", (RosettaPath)path, (String)LegacyResolutionValueOtherValues.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegacyResolutionValue legacyResolutionValue) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legacyResolutionValue).map("getCash", _legacyResolutionValue -> _legacyResolutionValue.getCash()), (Mapper)MapperS.of((Object)((Object)ValueCashEnum.OTHER)), (CardinalityOperator)CardinalityOperator.All).or(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legacyResolutionValue).map("getSecurities", _legacyResolutionValue -> _legacyResolutionValue.getSecurities()), (Mapper)MapperS.of((Object)((Object)ValueSecuritiesEnum.OTHER)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)legacyResolutionValue).map("getAdditionalLanguage", _legacyResolutionValue -> _legacyResolutionValue.getAdditionalLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

