/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.validation.datarule;

import cdm.legaldocumentation.csa.LegacyDefinition;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="LegacyDefinitionApplicableLanguage")
@ImplementedBy(value=Default.class)
public interface LegacyDefinitionApplicableLanguage
extends Validator<LegacyDefinition> {
    public static final String NAME = "LegacyDefinitionApplicableLanguage";
    public static final String DEFINITION = "if isApplicable = False then additionalLanguage exists";

    public static class NoOp
    implements LegacyDefinitionApplicableLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegacyDefinition legacyDefinition) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements LegacyDefinitionApplicableLanguage {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, LegacyDefinition legacyDefinition) {
            ComparisonResult result = this.executeDataRule(legacyDefinition);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)LegacyDefinitionApplicableLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegacyDefinition", (RosettaPath)path, (String)LegacyDefinitionApplicableLanguage.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)LegacyDefinitionApplicableLanguage.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"LegacyDefinition", (RosettaPath)path, (String)LegacyDefinitionApplicableLanguage.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(LegacyDefinition legacyDefinition) {
            try {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)legacyDefinition).map("getIsApplicable", _legacyDefinition -> _legacyDefinition.getIsApplicable()), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)legacyDefinition).map("getAdditionalLanguage", _legacyDefinition -> _legacyDefinition.getAdditionalLanguage()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

