/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.legaldocumentation.csa.RegulatoryRegimeEnum;
import cdm.legaldocumentation.csa.SubstitutedRegime;
import cdm.legaldocumentation.csa.SubstitutedRegimeTerms;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.translation.SynonymToEnumMap;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class SubstitutedRegimeHelper {
    private final RosettaPath path;
    private final List<Mapping> mappings;
    private final SynonymToEnumMap synonymToEnumMap;

    SubstitutedRegimeHelper(RosettaPath path, List<Mapping> mappings, SynonymToEnumMap synonymToEnumMap) {
        this.path = path;
        this.mappings = mappings;
        this.synonymToEnumMap = synonymToEnumMap;
    }

    public List<SubstitutedRegime> getSubstitutedRegimes(Path synonymPath) {
        List substitutedRegimes = this.mappings.stream().filter(m -> synonymPath.nameStartMatches(m.getXmlPath())).filter(m -> m.getXmlPath().getLastElement().getPathName().startsWith("partyA_") && !m.getXmlPath().getLastElement().getPathName().endsWith("additional_substituted_regime")).filter(m -> m.getXmlValue() != null).map(m -> this.getSubstitutedRegime(m.getXmlPath())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        List additionalSubstitutedRegimes = this.mappings.stream().filter(m -> synonymPath.append(Path.parse((String)"additional_substituted_regime.name")).nameStartMatches(m.getXmlPath())).filter(m -> m.getXmlValue() != null).map(this::getAdditionalSubstitutedRegime).collect(Collectors.toList());
        ArrayList<SubstitutedRegime> results = new ArrayList<SubstitutedRegime>();
        results.addAll(substitutedRegimes);
        results.addAll(additionalSubstitutedRegimes);
        return results;
    }

    private SubstitutedRegime getAdditionalSubstitutedRegime(Mapping additionalRegimeNameMapping) {
        SubstitutedRegime.SubstitutedRegimeBuilder substitutedRegimeBuilder = SubstitutedRegime.builder();
        MappingProcessorUtils.setValueAndUpdateMappings((Path)additionalRegimeNameMapping.getXmlPath(), substitutedRegimeBuilder::setAdditionalRegime, this.mappings, (RosettaPath)this.path);
        Integer index = additionalRegimeNameMapping.getXmlPath().getLastElement().getIndex().orElse(0);
        Path additionalSubstitutedRegimePath = additionalRegimeNameMapping.getXmlPath().getParent();
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getSubstitutedRegimeTerms(additionalSubstitutedRegimePath, (String)party, "additional_substituted_regime[" + index + "]").ifPresent(substitutedRegimeBuilder::addRegimeTerms));
        return substitutedRegimeBuilder.build();
    }

    private Optional<SubstitutedRegime> getSubstitutedRegime(Path synonymPath) {
        SubstitutedRegime.SubstitutedRegimeBuilder substitutedRegimeBuilder = SubstitutedRegime.builder();
        String regulatoryRegime = this.removePartyPrefix(synonymPath.getLastElement().getPathName());
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getSubstitutedRegimeTerms(synonymPath.getParent(), (String)party, regulatoryRegime).ifPresent(substitutedRegimeBuilder::addRegimeTerms));
        if (substitutedRegimeBuilder.hasData()) {
            RegulatoryRegimeEnum regulatoryRegimeEnum = (RegulatoryRegimeEnum)this.synonymToEnumMap.getEnumValue(RegulatoryRegimeEnum.class, regulatoryRegime);
            if (regulatoryRegimeEnum != null) {
                substitutedRegimeBuilder.setRegime(regulatoryRegimeEnum);
            } else {
                substitutedRegimeBuilder.setAdditionalRegime(regulatoryRegime);
            }
            return Optional.of(substitutedRegimeBuilder.build());
        }
        return Optional.empty();
    }

    private String removePartyPrefix(String pathName) {
        return pathName.substring(pathName.indexOf("_") + 1);
    }

    private Optional<SubstitutedRegimeTerms.SubstitutedRegimeTermsBuilder> getSubstitutedRegimeTerms(Path basePath, String party, String pathSuffix) {
        SubstitutedRegimeTerms.SubstitutedRegimeTermsBuilder substitutedRegimeTermsBuilder = SubstitutedRegimeTerms.builder();
        MappingProcessorUtils.setValueAndUpdateMappings((Path)basePath.append(Path.parse((String)(party + "_" + pathSuffix))), value -> {
            substitutedRegimeTermsBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party));
            substitutedRegimeTermsBuilder.setIsApplicable(value.equals("applicable"));
        }, this.mappings, (RosettaPath)this.path);
        return substitutedRegimeTermsBuilder.hasData() ? Optional.of(substitutedRegimeTermsBuilder) : Optional.empty();
    }
}

