/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.legaldocumentation.csa.CalculationCurrencyElection;
import cdm.legaldocumentation.csa.SimmCalculationCurrency;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class SimmCalculationCurrencyMappingProcessor
extends MappingProcessor {
    public SimmCalculationCurrencyMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        SimmCalculationCurrency.SimmCalculationCurrencyBuilder simmCalculationCurrencyBuilder = (SimmCalculationCurrency.SimmCalculationCurrencyBuilder)builder;
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getCalculationCurrencyElection(synonymPath, (String)party).ifPresent(simmCalculationCurrencyBuilder::addPartyElection));
    }

    private Optional<CalculationCurrencyElection> getCalculationCurrencyElection(Path synonymPath, String party) {
        CalculationCurrencyElection.CalculationCurrencyElectionBuilder calculationCurrencyElectionBuilder = CalculationCurrencyElection.builder();
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_use_base_currency"), value -> calculationCurrencyElectionBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party)).setIsBaseCurrency(Boolean.valueOf(value)));
        MappingProcessorUtils.setValueAndOptionallyUpdateMappings((Path)synonymPath.addElement(party + "_use_other_currency"), value -> CreateiQMappingProcessorUtils.setIsoCurrency((ISOCurrencyCodeEnum)this.getSynonymToEnumMap().getEnumValue(ISOCurrencyCodeEnum.class, value), calculationCurrencyElectionBuilder::setCurrency), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        return calculationCurrencyElectionBuilder.hasData() ? Optional.of(calculationCurrencyElectionBuilder.build()) : Optional.empty();
    }
}

