/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.base.staticdata.party.Account;
import cdm.base.staticdata.party.LegalEntity;
import cdm.legaldocumentation.csa.Custodian;
import cdm.legaldocumentation.csa.CustodianElection;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class CustodianMappingProcessor
extends MappingProcessor {
    public CustodianMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        Custodian.CustodianBuilder custodianBuilder = (Custodian.CustodianBuilder)builder;
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getCustodianElection(synonymPath, (String)party).ifPresent(custodianBuilder::addPartyElection));
    }

    private Optional<CustodianElection> getCustodianElection(Path synonymPath, String party) {
        CustodianElection.CustodianElectionBuilder custodianElectionBuilder = CustodianElection.builder();
        String suffix = synonymPath.endsWith(new String[]{"collateral_manager"}) ? "_specify" : "_custodian_name";
        this.setValueAndUpdateMappings(synonymPath.addElement(party + suffix), value -> custodianElectionBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party)).setCustodian(LegalEntity.builder().setName(CreateiQMappingProcessorUtils.toFieldWithMetaString(value))));
        if (synonymPath.endsWith(new String[]{"custodian_and_segregated_account_details"})) {
            this.setValueAndUpdateMappings(synonymPath.addElement(party + "_cash"), value -> custodianElectionBuilder.setSegregatedCashAccount(Account.builder().setAccountName(CreateiQMappingProcessorUtils.toFieldWithMetaString(value)).build()));
            this.setValueAndUpdateMappings(synonymPath.addElement(party + "_securities"), value -> custodianElectionBuilder.setSegregatedSecurityAccount(Account.builder().setAccountName(CreateiQMappingProcessorUtils.toFieldWithMetaString(value)).build()));
        }
        return custodianElectionBuilder.hasData() ? Optional.of(custodianElectionBuilder.build()) : Optional.empty();
    }
}

