/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.functions;

import cdm.base.math.RoundingModeEnum;
import cdm.base.math.functions.Max;
import cdm.base.math.functions.RoundToNearest;
import cdm.legaldocumentation.csa.CollateralRounding;
import cdm.legaldocumentation.csa.MarginApproachEnum;
import cdm.legaldocumentation.csa.PostedCreditSupportItem;
import cdm.legaldocumentation.csa.functions.CreditSupportAmount;
import cdm.legaldocumentation.csa.functions.UndisputedAdjustedPostedCreditSupportAmount;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=DeliveryAmountDefault.class)
public abstract class DeliveryAmount
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CreditSupportAmount creditSupportAmount0;
    @Inject
    protected Max max;
    @Inject
    protected RoundToNearest roundToNearest;
    @Inject
    protected UndisputedAdjustedPostedCreditSupportAmount undisputedAdjustedPostedCreditSupportAmount0;

    public Money evaluate(List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
        Money result;
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)minimumTransferAmount).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.areEqual((Mapper)MapperS.of((Object)baseCurrency), (Mapper)MapperS.of((Object)disputedDeliveryAmount).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.All)), "");
        Money.MoneyBuilder resultBuilder = this.doEvaluate(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency);
        if (resultBuilder == null) {
            result = null;
        } else {
            result = resultBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)result);
        }
        return result;
    }

    protected abstract Money.MoneyBuilder doEvaluate(List<? extends PostedCreditSupportItem> var1, Money var2, Money var3, Money var4, Money var5, Money var6, MarginApproachEnum var7, Money var8, Money var9, CollateralRounding var10, Money var11, String var12);

    protected abstract MapperS<? extends Money> undisputedAdjustedPostedCreditSupportAmount1(List<? extends PostedCreditSupportItem> var1, Money var2, Money var3, Money var4, Money var5, Money var6, MarginApproachEnum var7, Money var8, Money var9, CollateralRounding var10, Money var11, String var12);

    protected abstract MapperS<? extends Money> creditSupportAmount1(List<? extends PostedCreditSupportItem> var1, Money var2, Money var3, Money var4, Money var5, Money var6, MarginApproachEnum var7, Money var8, Money var9, CollateralRounding var10, Money var11, String var12);

    protected abstract MapperS<BigDecimal> deliveryAmount(List<? extends PostedCreditSupportItem> var1, Money var2, Money var3, Money var4, Money var5, Money var6, MarginApproachEnum var7, Money var8, Money var9, CollateralRounding var10, Money var11, String var12);

    protected abstract MapperS<BigDecimal> undisputedDeliveryAmount(List<? extends PostedCreditSupportItem> var1, Money var2, Money var3, Money var4, Money var5, Money var6, MarginApproachEnum var7, Money var8, Money var9, CollateralRounding var10, Money var11, String var12);

    public static class DeliveryAmountDefault
    extends DeliveryAmount {
        @Override
        protected Money.MoneyBuilder doEvaluate(List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
            if (postedCreditSupportItems == null) {
                postedCreditSupportItems = Collections.emptyList();
            }
            Money.MoneyBuilder result = Money.builder();
            return this.assignOutput(result, postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder result, List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
            BigDecimal ifThenElseResult = ExpressionOperators.greaterThanEquals(this.undisputedDeliveryAmount(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency), (Mapper)MapperS.of((Object)minimumTransferAmount).map("getValue", money -> money.getValue()), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.roundToNearest.evaluate((BigDecimal)this.undisputedDeliveryAmount(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency).get(), (BigDecimal)MapperS.of((Object)rounding).map("getDeliveryAmount", collateralRounding -> collateralRounding.getDeliveryAmount()).get(), RoundingModeEnum.UP) : new BigDecimal("0.0");
            result.setValue(ifThenElseResult);
            result.getOrCreateUnit().setCurrency(baseCurrency == null ? FieldWithMetaString.builder().build() : FieldWithMetaString.builder().setValue(baseCurrency).build());
            return Optional.ofNullable(result).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Money> undisputedAdjustedPostedCreditSupportAmount1(List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
            return MapperS.of((Object)this.undisputedAdjustedPostedCreditSupportAmount0.evaluate(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, baseCurrency));
        }

        @Override
        protected MapperS<? extends Money> creditSupportAmount1(List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
            return MapperS.of((Object)this.creditSupportAmount0.evaluate(marginAmount, threshold, marginApproach, marginAmountIA, baseCurrency));
        }

        @Override
        protected MapperS<BigDecimal> deliveryAmount(List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
            return MapperS.of((Object)this.max.evaluate((BigDecimal)MapperMaths.subtract((Mapper)this.creditSupportAmount1(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency).map("getValue", money -> money.getValue()), (Mapper)this.undisputedAdjustedPostedCreditSupportAmount1(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency).map("getValue", money -> money.getValue())).get(), new BigDecimal("0.0")));
        }

        @Override
        protected MapperS<BigDecimal> undisputedDeliveryAmount(List<? extends PostedCreditSupportItem> postedCreditSupportItems, Money priorDeliveryAmountAdjustment, Money priorReturnAmountAdjustment, Money disputedTransferredPostedCreditSupportAmount, Money marginAmount, Money threshold, MarginApproachEnum marginApproach, Money marginAmountIA, Money minimumTransferAmount, CollateralRounding rounding, Money disputedDeliveryAmount, String baseCurrency) {
            return MapperS.of((Object)this.max.evaluate((BigDecimal)MapperMaths.subtract(this.deliveryAmount(postedCreditSupportItems, priorDeliveryAmountAdjustment, priorReturnAmountAdjustment, disputedTransferredPostedCreditSupportAmount, marginAmount, threshold, marginApproach, marginAmountIA, minimumTransferAmount, rounding, disputedDeliveryAmount, baseCurrency), (Mapper)MapperS.of((Object)disputedDeliveryAmount).map("getValue", money -> money.getValue())).get(), new BigDecimal("0.0")));
        }
    }
}

