/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa;

import cdm.legaldocumentation.csa.BespokeTransferTiming;
import cdm.legaldocumentation.csa.CSAMinimumTransferAmount;
import cdm.legaldocumentation.csa.CSAThreshold;
import cdm.legaldocumentation.csa.CollateralRounding;
import cdm.legaldocumentation.csa.CollateralTransferTiming;
import cdm.legaldocumentation.csa.CreditSupportAmount;
import cdm.legaldocumentation.csa.CreditSupportObligationsVariationMargin;
import cdm.legaldocumentation.csa.LegacyDeliveryAmount;
import cdm.legaldocumentation.csa.LegacyReturnAmount;
import cdm.legaldocumentation.csa.MarginApproach;
import cdm.legaldocumentation.csa.MinimumTransferAmount;
import cdm.legaldocumentation.csa.Threshold;
import cdm.legaldocumentation.csa.meta.CreditSupportObligationsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditSupportObligations", builder=CreditSupportObligationsBuilderImpl.class, version="6.10.0")
@RuneDataType(value="CreditSupportObligations", model="cdm", builder=CreditSupportObligationsBuilderImpl.class, version="6.10.0")
public interface CreditSupportObligations
extends RosettaModelObject {
    public static final CreditSupportObligationsMeta metaData = new CreditSupportObligationsMeta();

    public String getDeliveryAmount();

    public String getReturnAmount();

    public MarginApproach getMarginApproach();

    public String getOtherEligibleSupport();

    public Threshold getThreshold();

    public MinimumTransferAmount getMinimumTransferAmount();

    public CollateralRounding getRounding();

    public BespokeTransferTiming getBespokeTransferTiming();

    public CreditSupportObligationsVariationMargin getCreditSupportObligationsVariationMargin();

    public List<? extends CSAThreshold> getLegacyThreshold();

    public List<? extends CSAMinimumTransferAmount> getLegacyMinimumTransferAmount();

    public LegacyDeliveryAmount getLegacyDeliveryAmount();

    public LegacyReturnAmount getLegacyReturnAmount();

    public CreditSupportAmount getCreditSupportAmount();

    public CollateralTransferTiming getCollateralTransferTiming();

    public CreditSupportObligations build();

    public CreditSupportObligationsBuilder toBuilder();

    public static CreditSupportObligationsBuilder builder() {
        return new CreditSupportObligationsBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditSupportObligations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditSupportObligations> getType() {
        return CreditSupportObligations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("deliveryAmount"), String.class, (Object)this.getDeliveryAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("returnAmount"), String.class, (Object)this.getReturnAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("marginApproach"), processor, MarginApproach.class, this.getMarginApproach(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherEligibleSupport"), String.class, (Object)this.getOtherEligibleSupport(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("threshold"), processor, Threshold.class, this.getThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumTransferAmount"), processor, MinimumTransferAmount.class, this.getMinimumTransferAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rounding"), processor, CollateralRounding.class, this.getRounding(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("bespokeTransferTiming"), processor, BespokeTransferTiming.class, this.getBespokeTransferTiming(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportObligationsVariationMargin"), processor, CreditSupportObligationsVariationMargin.class, this.getCreditSupportObligationsVariationMargin(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyThreshold"), processor, CSAThreshold.class, this.getLegacyThreshold(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyMinimumTransferAmount"), processor, CSAMinimumTransferAmount.class, this.getLegacyMinimumTransferAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyDeliveryAmount"), processor, LegacyDeliveryAmount.class, this.getLegacyDeliveryAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyReturnAmount"), processor, LegacyReturnAmount.class, this.getLegacyReturnAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditSupportAmount"), processor, CreditSupportAmount.class, this.getCreditSupportAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralTransferTiming"), processor, CollateralTransferTiming.class, this.getCollateralTransferTiming(), new AttributeMeta[0]);
    }

    public static class CreditSupportObligationsBuilderImpl
    implements CreditSupportObligationsBuilder {
        protected String deliveryAmount;
        protected String returnAmount;
        protected MarginApproach.MarginApproachBuilder marginApproach;
        protected String otherEligibleSupport;
        protected Threshold.ThresholdBuilder threshold;
        protected MinimumTransferAmount.MinimumTransferAmountBuilder minimumTransferAmount;
        protected CollateralRounding.CollateralRoundingBuilder rounding;
        protected BespokeTransferTiming.BespokeTransferTimingBuilder bespokeTransferTiming;
        protected CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder creditSupportObligationsVariationMargin;
        protected List<CSAThreshold.CSAThresholdBuilder> legacyThreshold = new ArrayList<CSAThreshold.CSAThresholdBuilder>();
        protected List<CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder> legacyMinimumTransferAmount = new ArrayList<CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder>();
        protected LegacyDeliveryAmount.LegacyDeliveryAmountBuilder legacyDeliveryAmount;
        protected LegacyReturnAmount.LegacyReturnAmountBuilder legacyReturnAmount;
        protected CreditSupportAmount.CreditSupportAmountBuilder creditSupportAmount;
        protected CollateralTransferTiming.CollateralTransferTimingBuilder collateralTransferTiming;

        @Override
        @RosettaAttribute(value="deliveryAmount")
        @RuneAttribute(value="deliveryAmount")
        public String getDeliveryAmount() {
            return this.deliveryAmount;
        }

        @Override
        @RosettaAttribute(value="returnAmount")
        @RuneAttribute(value="returnAmount")
        public String getReturnAmount() {
            return this.returnAmount;
        }

        @Override
        @RosettaAttribute(value="marginApproach")
        @RuneAttribute(value="marginApproach")
        public MarginApproach.MarginApproachBuilder getMarginApproach() {
            return this.marginApproach;
        }

        @Override
        public MarginApproach.MarginApproachBuilder getOrCreateMarginApproach() {
            MarginApproach.MarginApproachBuilder result = this.marginApproach != null ? this.marginApproach : (this.marginApproach = MarginApproach.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="otherEligibleSupport")
        @RuneAttribute(value="otherEligibleSupport")
        public String getOtherEligibleSupport() {
            return this.otherEligibleSupport;
        }

        @Override
        @RosettaAttribute(value="threshold", isRequired=true)
        @RuneAttribute(value="threshold", isRequired=true)
        public Threshold.ThresholdBuilder getThreshold() {
            return this.threshold;
        }

        @Override
        public Threshold.ThresholdBuilder getOrCreateThreshold() {
            Threshold.ThresholdBuilder result = this.threshold != null ? this.threshold : (this.threshold = Threshold.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmount", isRequired=true)
        @RuneAttribute(value="minimumTransferAmount", isRequired=true)
        public MinimumTransferAmount.MinimumTransferAmountBuilder getMinimumTransferAmount() {
            return this.minimumTransferAmount;
        }

        @Override
        public MinimumTransferAmount.MinimumTransferAmountBuilder getOrCreateMinimumTransferAmount() {
            MinimumTransferAmount.MinimumTransferAmountBuilder result = this.minimumTransferAmount != null ? this.minimumTransferAmount : (this.minimumTransferAmount = MinimumTransferAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CollateralRounding.CollateralRoundingBuilder getRounding() {
            return this.rounding;
        }

        @Override
        public CollateralRounding.CollateralRoundingBuilder getOrCreateRounding() {
            CollateralRounding.CollateralRoundingBuilder result = this.rounding != null ? this.rounding : (this.rounding = CollateralRounding.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bespokeTransferTiming")
        @RuneAttribute(value="bespokeTransferTiming")
        public BespokeTransferTiming.BespokeTransferTimingBuilder getBespokeTransferTiming() {
            return this.bespokeTransferTiming;
        }

        @Override
        public BespokeTransferTiming.BespokeTransferTimingBuilder getOrCreateBespokeTransferTiming() {
            BespokeTransferTiming.BespokeTransferTimingBuilder result = this.bespokeTransferTiming != null ? this.bespokeTransferTiming : (this.bespokeTransferTiming = BespokeTransferTiming.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportObligationsVariationMargin")
        @RuneAttribute(value="creditSupportObligationsVariationMargin")
        public CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder getCreditSupportObligationsVariationMargin() {
            return this.creditSupportObligationsVariationMargin;
        }

        @Override
        public CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder getOrCreateCreditSupportObligationsVariationMargin() {
            CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder result = this.creditSupportObligationsVariationMargin != null ? this.creditSupportObligationsVariationMargin : (this.creditSupportObligationsVariationMargin = CreditSupportObligationsVariationMargin.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyThreshold")
        @RuneAttribute(value="legacyThreshold")
        public List<? extends CSAThreshold.CSAThresholdBuilder> getLegacyThreshold() {
            return this.legacyThreshold;
        }

        @Override
        public CSAThreshold.CSAThresholdBuilder getOrCreateLegacyThreshold(int index) {
            if (this.legacyThreshold == null) {
                this.legacyThreshold = new ArrayList<CSAThreshold.CSAThresholdBuilder>();
            }
            return (CSAThreshold.CSAThresholdBuilder)this.getIndex(this.legacyThreshold, index, () -> {
                CSAThreshold.CSAThresholdBuilder newLegacyThreshold = CSAThreshold.builder();
                return newLegacyThreshold;
            });
        }

        @Override
        @RosettaAttribute(value="legacyMinimumTransferAmount")
        @RuneAttribute(value="legacyMinimumTransferAmount")
        public List<? extends CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder> getLegacyMinimumTransferAmount() {
            return this.legacyMinimumTransferAmount;
        }

        @Override
        public CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder getOrCreateLegacyMinimumTransferAmount(int index) {
            if (this.legacyMinimumTransferAmount == null) {
                this.legacyMinimumTransferAmount = new ArrayList<CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder>();
            }
            return (CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder)this.getIndex(this.legacyMinimumTransferAmount, index, () -> {
                CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder newLegacyMinimumTransferAmount = CSAMinimumTransferAmount.builder();
                return newLegacyMinimumTransferAmount;
            });
        }

        @Override
        @RosettaAttribute(value="legacyDeliveryAmount", isRequired=true)
        @RuneAttribute(value="legacyDeliveryAmount", isRequired=true)
        public LegacyDeliveryAmount.LegacyDeliveryAmountBuilder getLegacyDeliveryAmount() {
            return this.legacyDeliveryAmount;
        }

        @Override
        public LegacyDeliveryAmount.LegacyDeliveryAmountBuilder getOrCreateLegacyDeliveryAmount() {
            LegacyDeliveryAmount.LegacyDeliveryAmountBuilder result = this.legacyDeliveryAmount != null ? this.legacyDeliveryAmount : (this.legacyDeliveryAmount = LegacyDeliveryAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyReturnAmount", isRequired=true)
        @RuneAttribute(value="legacyReturnAmount", isRequired=true)
        public LegacyReturnAmount.LegacyReturnAmountBuilder getLegacyReturnAmount() {
            return this.legacyReturnAmount;
        }

        @Override
        public LegacyReturnAmount.LegacyReturnAmountBuilder getOrCreateLegacyReturnAmount() {
            LegacyReturnAmount.LegacyReturnAmountBuilder result = this.legacyReturnAmount != null ? this.legacyReturnAmount : (this.legacyReturnAmount = LegacyReturnAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditSupportAmount", isRequired=true)
        @RuneAttribute(value="creditSupportAmount", isRequired=true)
        public CreditSupportAmount.CreditSupportAmountBuilder getCreditSupportAmount() {
            return this.creditSupportAmount;
        }

        @Override
        public CreditSupportAmount.CreditSupportAmountBuilder getOrCreateCreditSupportAmount() {
            CreditSupportAmount.CreditSupportAmountBuilder result = this.creditSupportAmount != null ? this.creditSupportAmount : (this.creditSupportAmount = CreditSupportAmount.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralTransferTiming")
        @RuneAttribute(value="collateralTransferTiming")
        public CollateralTransferTiming.CollateralTransferTimingBuilder getCollateralTransferTiming() {
            return this.collateralTransferTiming;
        }

        @Override
        public CollateralTransferTiming.CollateralTransferTimingBuilder getOrCreateCollateralTransferTiming() {
            CollateralTransferTiming.CollateralTransferTimingBuilder result = this.collateralTransferTiming != null ? this.collateralTransferTiming : (this.collateralTransferTiming = CollateralTransferTiming.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="deliveryAmount")
        @RuneAttribute(value="deliveryAmount")
        public CreditSupportObligationsBuilder setDeliveryAmount(String _deliveryAmount) {
            this.deliveryAmount = _deliveryAmount == null ? null : _deliveryAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="returnAmount")
        @RuneAttribute(value="returnAmount")
        public CreditSupportObligationsBuilder setReturnAmount(String _returnAmount) {
            this.returnAmount = _returnAmount == null ? null : _returnAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="marginApproach")
        @RuneAttribute(value="marginApproach")
        public CreditSupportObligationsBuilder setMarginApproach(MarginApproach _marginApproach) {
            this.marginApproach = _marginApproach == null ? null : _marginApproach.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherEligibleSupport")
        @RuneAttribute(value="otherEligibleSupport")
        public CreditSupportObligationsBuilder setOtherEligibleSupport(String _otherEligibleSupport) {
            this.otherEligibleSupport = _otherEligibleSupport == null ? null : _otherEligibleSupport;
            return this;
        }

        @Override
        @RosettaAttribute(value="threshold", isRequired=true)
        @RuneAttribute(value="threshold", isRequired=true)
        public CreditSupportObligationsBuilder setThreshold(Threshold _threshold) {
            this.threshold = _threshold == null ? null : _threshold.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmount", isRequired=true)
        @RuneAttribute(value="minimumTransferAmount", isRequired=true)
        public CreditSupportObligationsBuilder setMinimumTransferAmount(MinimumTransferAmount _minimumTransferAmount) {
            this.minimumTransferAmount = _minimumTransferAmount == null ? null : _minimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CreditSupportObligationsBuilder setRounding(CollateralRounding _rounding) {
            this.rounding = _rounding == null ? null : _rounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="bespokeTransferTiming")
        @RuneAttribute(value="bespokeTransferTiming")
        public CreditSupportObligationsBuilder setBespokeTransferTiming(BespokeTransferTiming _bespokeTransferTiming) {
            this.bespokeTransferTiming = _bespokeTransferTiming == null ? null : _bespokeTransferTiming.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportObligationsVariationMargin")
        @RuneAttribute(value="creditSupportObligationsVariationMargin")
        public CreditSupportObligationsBuilder setCreditSupportObligationsVariationMargin(CreditSupportObligationsVariationMargin _creditSupportObligationsVariationMargin) {
            this.creditSupportObligationsVariationMargin = _creditSupportObligationsVariationMargin == null ? null : _creditSupportObligationsVariationMargin.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyThreshold")
        @RuneAttribute(value="legacyThreshold")
        public CreditSupportObligationsBuilder addLegacyThreshold(CSAThreshold _legacyThreshold) {
            if (_legacyThreshold != null) {
                this.legacyThreshold.add(_legacyThreshold.toBuilder());
            }
            return this;
        }

        @Override
        public CreditSupportObligationsBuilder addLegacyThreshold(CSAThreshold _legacyThreshold, int idx) {
            this.getIndex(this.legacyThreshold, idx, () -> _legacyThreshold.toBuilder());
            return this;
        }

        @Override
        public CreditSupportObligationsBuilder addLegacyThreshold(List<? extends CSAThreshold> legacyThresholds) {
            if (legacyThresholds != null) {
                for (CSAThreshold cSAThreshold : legacyThresholds) {
                    this.legacyThreshold.add(cSAThreshold.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legacyThreshold")
        public CreditSupportObligationsBuilder setLegacyThreshold(List<? extends CSAThreshold> legacyThresholds) {
            this.legacyThreshold = legacyThresholds == null ? new ArrayList<CSAThreshold.CSAThresholdBuilder>() : (List)legacyThresholds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyMinimumTransferAmount")
        @RuneAttribute(value="legacyMinimumTransferAmount")
        public CreditSupportObligationsBuilder addLegacyMinimumTransferAmount(CSAMinimumTransferAmount _legacyMinimumTransferAmount) {
            if (_legacyMinimumTransferAmount != null) {
                this.legacyMinimumTransferAmount.add(_legacyMinimumTransferAmount.toBuilder());
            }
            return this;
        }

        @Override
        public CreditSupportObligationsBuilder addLegacyMinimumTransferAmount(CSAMinimumTransferAmount _legacyMinimumTransferAmount, int idx) {
            this.getIndex(this.legacyMinimumTransferAmount, idx, () -> _legacyMinimumTransferAmount.toBuilder());
            return this;
        }

        @Override
        public CreditSupportObligationsBuilder addLegacyMinimumTransferAmount(List<? extends CSAMinimumTransferAmount> legacyMinimumTransferAmounts) {
            if (legacyMinimumTransferAmounts != null) {
                for (CSAMinimumTransferAmount cSAMinimumTransferAmount : legacyMinimumTransferAmounts) {
                    this.legacyMinimumTransferAmount.add(cSAMinimumTransferAmount.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="legacyMinimumTransferAmount")
        public CreditSupportObligationsBuilder setLegacyMinimumTransferAmount(List<? extends CSAMinimumTransferAmount> legacyMinimumTransferAmounts) {
            this.legacyMinimumTransferAmount = legacyMinimumTransferAmounts == null ? new ArrayList<CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder>() : (List)legacyMinimumTransferAmounts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyDeliveryAmount", isRequired=true)
        @RuneAttribute(value="legacyDeliveryAmount", isRequired=true)
        public CreditSupportObligationsBuilder setLegacyDeliveryAmount(LegacyDeliveryAmount _legacyDeliveryAmount) {
            this.legacyDeliveryAmount = _legacyDeliveryAmount == null ? null : _legacyDeliveryAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyReturnAmount", isRequired=true)
        @RuneAttribute(value="legacyReturnAmount", isRequired=true)
        public CreditSupportObligationsBuilder setLegacyReturnAmount(LegacyReturnAmount _legacyReturnAmount) {
            this.legacyReturnAmount = _legacyReturnAmount == null ? null : _legacyReturnAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditSupportAmount", isRequired=true)
        @RuneAttribute(value="creditSupportAmount", isRequired=true)
        public CreditSupportObligationsBuilder setCreditSupportAmount(CreditSupportAmount _creditSupportAmount) {
            this.creditSupportAmount = _creditSupportAmount == null ? null : _creditSupportAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTransferTiming")
        @RuneAttribute(value="collateralTransferTiming")
        public CreditSupportObligationsBuilder setCollateralTransferTiming(CollateralTransferTiming _collateralTransferTiming) {
            this.collateralTransferTiming = _collateralTransferTiming == null ? null : _collateralTransferTiming.toBuilder();
            return this;
        }

        @Override
        public CreditSupportObligations build() {
            return new CreditSupportObligationsImpl(this);
        }

        @Override
        public CreditSupportObligationsBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditSupportObligationsBuilder prune() {
            if (this.marginApproach != null && !this.marginApproach.prune().hasData()) {
                this.marginApproach = null;
            }
            if (this.threshold != null && !this.threshold.prune().hasData()) {
                this.threshold = null;
            }
            if (this.minimumTransferAmount != null && !this.minimumTransferAmount.prune().hasData()) {
                this.minimumTransferAmount = null;
            }
            if (this.rounding != null && !this.rounding.prune().hasData()) {
                this.rounding = null;
            }
            if (this.bespokeTransferTiming != null && !this.bespokeTransferTiming.prune().hasData()) {
                this.bespokeTransferTiming = null;
            }
            if (this.creditSupportObligationsVariationMargin != null && !this.creditSupportObligationsVariationMargin.prune().hasData()) {
                this.creditSupportObligationsVariationMargin = null;
            }
            this.legacyThreshold = this.legacyThreshold.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.legacyMinimumTransferAmount = this.legacyMinimumTransferAmount.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.legacyDeliveryAmount != null && !this.legacyDeliveryAmount.prune().hasData()) {
                this.legacyDeliveryAmount = null;
            }
            if (this.legacyReturnAmount != null && !this.legacyReturnAmount.prune().hasData()) {
                this.legacyReturnAmount = null;
            }
            if (this.creditSupportAmount != null && !this.creditSupportAmount.prune().hasData()) {
                this.creditSupportAmount = null;
            }
            if (this.collateralTransferTiming != null && !this.collateralTransferTiming.prune().hasData()) {
                this.collateralTransferTiming = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getDeliveryAmount() != null) {
                return true;
            }
            if (this.getReturnAmount() != null) {
                return true;
            }
            if (this.getMarginApproach() != null && this.getMarginApproach().hasData()) {
                return true;
            }
            if (this.getOtherEligibleSupport() != null) {
                return true;
            }
            if (this.getThreshold() != null && this.getThreshold().hasData()) {
                return true;
            }
            if (this.getMinimumTransferAmount() != null && this.getMinimumTransferAmount().hasData()) {
                return true;
            }
            if (this.getRounding() != null && this.getRounding().hasData()) {
                return true;
            }
            if (this.getBespokeTransferTiming() != null && this.getBespokeTransferTiming().hasData()) {
                return true;
            }
            if (this.getCreditSupportObligationsVariationMargin() != null && this.getCreditSupportObligationsVariationMargin().hasData()) {
                return true;
            }
            if (this.getLegacyThreshold() != null && this.getLegacyThreshold().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLegacyMinimumTransferAmount() != null && this.getLegacyMinimumTransferAmount().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLegacyDeliveryAmount() != null && this.getLegacyDeliveryAmount().hasData()) {
                return true;
            }
            if (this.getLegacyReturnAmount() != null && this.getLegacyReturnAmount().hasData()) {
                return true;
            }
            if (this.getCreditSupportAmount() != null && this.getCreditSupportAmount().hasData()) {
                return true;
            }
            return this.getCollateralTransferTiming() != null && this.getCollateralTransferTiming().hasData();
        }

        public CreditSupportObligationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditSupportObligationsBuilder o = (CreditSupportObligationsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMarginApproach(), (RosettaModelObjectBuilder)o.getMarginApproach(), this::setMarginApproach);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getThreshold(), (RosettaModelObjectBuilder)o.getThreshold(), this::setThreshold);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumTransferAmount(), (RosettaModelObjectBuilder)o.getMinimumTransferAmount(), this::setMinimumTransferAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRounding(), (RosettaModelObjectBuilder)o.getRounding(), this::setRounding);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBespokeTransferTiming(), (RosettaModelObjectBuilder)o.getBespokeTransferTiming(), this::setBespokeTransferTiming);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditSupportObligationsVariationMargin(), (RosettaModelObjectBuilder)o.getCreditSupportObligationsVariationMargin(), this::setCreditSupportObligationsVariationMargin);
            merger.mergeRosetta(this.getLegacyThreshold(), o.getLegacyThreshold(), this::getOrCreateLegacyThreshold);
            merger.mergeRosetta(this.getLegacyMinimumTransferAmount(), o.getLegacyMinimumTransferAmount(), this::getOrCreateLegacyMinimumTransferAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyDeliveryAmount(), (RosettaModelObjectBuilder)o.getLegacyDeliveryAmount(), this::setLegacyDeliveryAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyReturnAmount(), (RosettaModelObjectBuilder)o.getLegacyReturnAmount(), this::setLegacyReturnAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCreditSupportAmount(), (RosettaModelObjectBuilder)o.getCreditSupportAmount(), this::setCreditSupportAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCollateralTransferTiming(), (RosettaModelObjectBuilder)o.getCollateralTransferTiming(), this::setCollateralTransferTiming);
            merger.mergeBasic((Object)this.getDeliveryAmount(), (Object)o.getDeliveryAmount(), this::setDeliveryAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReturnAmount(), (Object)o.getReturnAmount(), this::setReturnAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOtherEligibleSupport(), (Object)o.getOtherEligibleSupport(), this::setOtherEligibleSupport, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportObligations _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryAmount, _that.getDeliveryAmount())) {
                return false;
            }
            if (!Objects.equals(this.returnAmount, _that.getReturnAmount())) {
                return false;
            }
            if (!Objects.equals(this.marginApproach, _that.getMarginApproach())) {
                return false;
            }
            if (!Objects.equals(this.otherEligibleSupport, _that.getOtherEligibleSupport())) {
                return false;
            }
            if (!Objects.equals(this.threshold, _that.getThreshold())) {
                return false;
            }
            if (!Objects.equals(this.minimumTransferAmount, _that.getMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals(this.bespokeTransferTiming, _that.getBespokeTransferTiming())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportObligationsVariationMargin, _that.getCreditSupportObligationsVariationMargin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legacyThreshold, _that.getLegacyThreshold())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legacyMinimumTransferAmount, _that.getLegacyMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.legacyDeliveryAmount, _that.getLegacyDeliveryAmount())) {
                return false;
            }
            if (!Objects.equals(this.legacyReturnAmount, _that.getLegacyReturnAmount())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportAmount, _that.getCreditSupportAmount())) {
                return false;
            }
            return Objects.equals(this.collateralTransferTiming, _that.getCollateralTransferTiming());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryAmount != null ? this.deliveryAmount.hashCode() : 0);
            _result = 31 * _result + (this.returnAmount != null ? this.returnAmount.hashCode() : 0);
            _result = 31 * _result + (this.marginApproach != null ? this.marginApproach.hashCode() : 0);
            _result = 31 * _result + (this.otherEligibleSupport != null ? this.otherEligibleSupport.hashCode() : 0);
            _result = 31 * _result + (this.threshold != null ? this.threshold.hashCode() : 0);
            _result = 31 * _result + (this.minimumTransferAmount != null ? this.minimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.bespokeTransferTiming != null ? this.bespokeTransferTiming.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportObligationsVariationMargin != null ? this.creditSupportObligationsVariationMargin.hashCode() : 0);
            _result = 31 * _result + (this.legacyThreshold != null ? this.legacyThreshold.hashCode() : 0);
            _result = 31 * _result + (this.legacyMinimumTransferAmount != null ? this.legacyMinimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.legacyDeliveryAmount != null ? this.legacyDeliveryAmount.hashCode() : 0);
            _result = 31 * _result + (this.legacyReturnAmount != null ? this.legacyReturnAmount.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportAmount != null ? this.creditSupportAmount.hashCode() : 0);
            _result = 31 * _result + (this.collateralTransferTiming != null ? this.collateralTransferTiming.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportObligationsBuilder {deliveryAmount=" + this.deliveryAmount + ", returnAmount=" + this.returnAmount + ", marginApproach=" + this.marginApproach + ", otherEligibleSupport=" + this.otherEligibleSupport + ", threshold=" + this.threshold + ", minimumTransferAmount=" + this.minimumTransferAmount + ", rounding=" + this.rounding + ", bespokeTransferTiming=" + this.bespokeTransferTiming + ", creditSupportObligationsVariationMargin=" + this.creditSupportObligationsVariationMargin + ", legacyThreshold=" + this.legacyThreshold + ", legacyMinimumTransferAmount=" + this.legacyMinimumTransferAmount + ", legacyDeliveryAmount=" + this.legacyDeliveryAmount + ", legacyReturnAmount=" + this.legacyReturnAmount + ", creditSupportAmount=" + this.creditSupportAmount + ", collateralTransferTiming=" + this.collateralTransferTiming + '}';
        }
    }

    public static interface CreditSupportObligationsBuilder
    extends CreditSupportObligations,
    RosettaModelObjectBuilder {
        public MarginApproach.MarginApproachBuilder getOrCreateMarginApproach();

        @Override
        public MarginApproach.MarginApproachBuilder getMarginApproach();

        public Threshold.ThresholdBuilder getOrCreateThreshold();

        @Override
        public Threshold.ThresholdBuilder getThreshold();

        public MinimumTransferAmount.MinimumTransferAmountBuilder getOrCreateMinimumTransferAmount();

        @Override
        public MinimumTransferAmount.MinimumTransferAmountBuilder getMinimumTransferAmount();

        public CollateralRounding.CollateralRoundingBuilder getOrCreateRounding();

        @Override
        public CollateralRounding.CollateralRoundingBuilder getRounding();

        public BespokeTransferTiming.BespokeTransferTimingBuilder getOrCreateBespokeTransferTiming();

        @Override
        public BespokeTransferTiming.BespokeTransferTimingBuilder getBespokeTransferTiming();

        public CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder getOrCreateCreditSupportObligationsVariationMargin();

        @Override
        public CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder getCreditSupportObligationsVariationMargin();

        public CSAThreshold.CSAThresholdBuilder getOrCreateLegacyThreshold(int var1);

        public List<? extends CSAThreshold.CSAThresholdBuilder> getLegacyThreshold();

        public CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder getOrCreateLegacyMinimumTransferAmount(int var1);

        public List<? extends CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder> getLegacyMinimumTransferAmount();

        public LegacyDeliveryAmount.LegacyDeliveryAmountBuilder getOrCreateLegacyDeliveryAmount();

        @Override
        public LegacyDeliveryAmount.LegacyDeliveryAmountBuilder getLegacyDeliveryAmount();

        public LegacyReturnAmount.LegacyReturnAmountBuilder getOrCreateLegacyReturnAmount();

        @Override
        public LegacyReturnAmount.LegacyReturnAmountBuilder getLegacyReturnAmount();

        public CreditSupportAmount.CreditSupportAmountBuilder getOrCreateCreditSupportAmount();

        @Override
        public CreditSupportAmount.CreditSupportAmountBuilder getCreditSupportAmount();

        public CollateralTransferTiming.CollateralTransferTimingBuilder getOrCreateCollateralTransferTiming();

        @Override
        public CollateralTransferTiming.CollateralTransferTimingBuilder getCollateralTransferTiming();

        public CreditSupportObligationsBuilder setDeliveryAmount(String var1);

        public CreditSupportObligationsBuilder setReturnAmount(String var1);

        public CreditSupportObligationsBuilder setMarginApproach(MarginApproach var1);

        public CreditSupportObligationsBuilder setOtherEligibleSupport(String var1);

        public CreditSupportObligationsBuilder setThreshold(Threshold var1);

        public CreditSupportObligationsBuilder setMinimumTransferAmount(MinimumTransferAmount var1);

        public CreditSupportObligationsBuilder setRounding(CollateralRounding var1);

        public CreditSupportObligationsBuilder setBespokeTransferTiming(BespokeTransferTiming var1);

        public CreditSupportObligationsBuilder setCreditSupportObligationsVariationMargin(CreditSupportObligationsVariationMargin var1);

        public CreditSupportObligationsBuilder addLegacyThreshold(CSAThreshold var1);

        public CreditSupportObligationsBuilder addLegacyThreshold(CSAThreshold var1, int var2);

        public CreditSupportObligationsBuilder addLegacyThreshold(List<? extends CSAThreshold> var1);

        public CreditSupportObligationsBuilder setLegacyThreshold(List<? extends CSAThreshold> var1);

        public CreditSupportObligationsBuilder addLegacyMinimumTransferAmount(CSAMinimumTransferAmount var1);

        public CreditSupportObligationsBuilder addLegacyMinimumTransferAmount(CSAMinimumTransferAmount var1, int var2);

        public CreditSupportObligationsBuilder addLegacyMinimumTransferAmount(List<? extends CSAMinimumTransferAmount> var1);

        public CreditSupportObligationsBuilder setLegacyMinimumTransferAmount(List<? extends CSAMinimumTransferAmount> var1);

        public CreditSupportObligationsBuilder setLegacyDeliveryAmount(LegacyDeliveryAmount var1);

        public CreditSupportObligationsBuilder setLegacyReturnAmount(LegacyReturnAmount var1);

        public CreditSupportObligationsBuilder setCreditSupportAmount(CreditSupportAmount var1);

        public CreditSupportObligationsBuilder setCollateralTransferTiming(CollateralTransferTiming var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("deliveryAmount"), String.class, (Object)this.getDeliveryAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("returnAmount"), String.class, (Object)this.getReturnAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("marginApproach"), processor, MarginApproach.MarginApproachBuilder.class, this.getMarginApproach(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherEligibleSupport"), String.class, (Object)this.getOtherEligibleSupport(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("threshold"), processor, Threshold.ThresholdBuilder.class, this.getThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumTransferAmount"), processor, MinimumTransferAmount.MinimumTransferAmountBuilder.class, this.getMinimumTransferAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rounding"), processor, CollateralRounding.CollateralRoundingBuilder.class, this.getRounding(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("bespokeTransferTiming"), processor, BespokeTransferTiming.BespokeTransferTimingBuilder.class, this.getBespokeTransferTiming(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportObligationsVariationMargin"), processor, CreditSupportObligationsVariationMargin.CreditSupportObligationsVariationMarginBuilder.class, this.getCreditSupportObligationsVariationMargin(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyThreshold"), processor, CSAThreshold.CSAThresholdBuilder.class, this.getLegacyThreshold(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyMinimumTransferAmount"), processor, CSAMinimumTransferAmount.CSAMinimumTransferAmountBuilder.class, this.getLegacyMinimumTransferAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyDeliveryAmount"), processor, LegacyDeliveryAmount.LegacyDeliveryAmountBuilder.class, this.getLegacyDeliveryAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyReturnAmount"), processor, LegacyReturnAmount.LegacyReturnAmountBuilder.class, this.getLegacyReturnAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditSupportAmount"), processor, CreditSupportAmount.CreditSupportAmountBuilder.class, this.getCreditSupportAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralTransferTiming"), processor, CollateralTransferTiming.CollateralTransferTimingBuilder.class, this.getCollateralTransferTiming(), new AttributeMeta[0]);
        }

        public CreditSupportObligationsBuilder prune();
    }

    public static class CreditSupportObligationsImpl
    implements CreditSupportObligations {
        private final String deliveryAmount;
        private final String returnAmount;
        private final MarginApproach marginApproach;
        private final String otherEligibleSupport;
        private final Threshold threshold;
        private final MinimumTransferAmount minimumTransferAmount;
        private final CollateralRounding rounding;
        private final BespokeTransferTiming bespokeTransferTiming;
        private final CreditSupportObligationsVariationMargin creditSupportObligationsVariationMargin;
        private final List<? extends CSAThreshold> legacyThreshold;
        private final List<? extends CSAMinimumTransferAmount> legacyMinimumTransferAmount;
        private final LegacyDeliveryAmount legacyDeliveryAmount;
        private final LegacyReturnAmount legacyReturnAmount;
        private final CreditSupportAmount creditSupportAmount;
        private final CollateralTransferTiming collateralTransferTiming;

        protected CreditSupportObligationsImpl(CreditSupportObligationsBuilder builder) {
            this.deliveryAmount = builder.getDeliveryAmount();
            this.returnAmount = builder.getReturnAmount();
            this.marginApproach = Optional.ofNullable(builder.getMarginApproach()).map(f -> f.build()).orElse(null);
            this.otherEligibleSupport = builder.getOtherEligibleSupport();
            this.threshold = Optional.ofNullable(builder.getThreshold()).map(f -> f.build()).orElse(null);
            this.minimumTransferAmount = Optional.ofNullable(builder.getMinimumTransferAmount()).map(f -> f.build()).orElse(null);
            this.rounding = Optional.ofNullable(builder.getRounding()).map(f -> f.build()).orElse(null);
            this.bespokeTransferTiming = Optional.ofNullable(builder.getBespokeTransferTiming()).map(f -> f.build()).orElse(null);
            this.creditSupportObligationsVariationMargin = Optional.ofNullable(builder.getCreditSupportObligationsVariationMargin()).map(f -> f.build()).orElse(null);
            this.legacyThreshold = Optional.ofNullable(builder.getLegacyThreshold()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.legacyMinimumTransferAmount = Optional.ofNullable(builder.getLegacyMinimumTransferAmount()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.legacyDeliveryAmount = Optional.ofNullable(builder.getLegacyDeliveryAmount()).map(f -> f.build()).orElse(null);
            this.legacyReturnAmount = Optional.ofNullable(builder.getLegacyReturnAmount()).map(f -> f.build()).orElse(null);
            this.creditSupportAmount = Optional.ofNullable(builder.getCreditSupportAmount()).map(f -> f.build()).orElse(null);
            this.collateralTransferTiming = Optional.ofNullable(builder.getCollateralTransferTiming()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="deliveryAmount")
        @RuneAttribute(value="deliveryAmount")
        public String getDeliveryAmount() {
            return this.deliveryAmount;
        }

        @Override
        @RosettaAttribute(value="returnAmount")
        @RuneAttribute(value="returnAmount")
        public String getReturnAmount() {
            return this.returnAmount;
        }

        @Override
        @RosettaAttribute(value="marginApproach")
        @RuneAttribute(value="marginApproach")
        public MarginApproach getMarginApproach() {
            return this.marginApproach;
        }

        @Override
        @RosettaAttribute(value="otherEligibleSupport")
        @RuneAttribute(value="otherEligibleSupport")
        public String getOtherEligibleSupport() {
            return this.otherEligibleSupport;
        }

        @Override
        @RosettaAttribute(value="threshold", isRequired=true)
        @RuneAttribute(value="threshold", isRequired=true)
        public Threshold getThreshold() {
            return this.threshold;
        }

        @Override
        @RosettaAttribute(value="minimumTransferAmount", isRequired=true)
        @RuneAttribute(value="minimumTransferAmount", isRequired=true)
        public MinimumTransferAmount getMinimumTransferAmount() {
            return this.minimumTransferAmount;
        }

        @Override
        @RosettaAttribute(value="rounding")
        @RuneAttribute(value="rounding")
        public CollateralRounding getRounding() {
            return this.rounding;
        }

        @Override
        @RosettaAttribute(value="bespokeTransferTiming")
        @RuneAttribute(value="bespokeTransferTiming")
        public BespokeTransferTiming getBespokeTransferTiming() {
            return this.bespokeTransferTiming;
        }

        @Override
        @RosettaAttribute(value="creditSupportObligationsVariationMargin")
        @RuneAttribute(value="creditSupportObligationsVariationMargin")
        public CreditSupportObligationsVariationMargin getCreditSupportObligationsVariationMargin() {
            return this.creditSupportObligationsVariationMargin;
        }

        @Override
        @RosettaAttribute(value="legacyThreshold")
        @RuneAttribute(value="legacyThreshold")
        public List<? extends CSAThreshold> getLegacyThreshold() {
            return this.legacyThreshold;
        }

        @Override
        @RosettaAttribute(value="legacyMinimumTransferAmount")
        @RuneAttribute(value="legacyMinimumTransferAmount")
        public List<? extends CSAMinimumTransferAmount> getLegacyMinimumTransferAmount() {
            return this.legacyMinimumTransferAmount;
        }

        @Override
        @RosettaAttribute(value="legacyDeliveryAmount", isRequired=true)
        @RuneAttribute(value="legacyDeliveryAmount", isRequired=true)
        public LegacyDeliveryAmount getLegacyDeliveryAmount() {
            return this.legacyDeliveryAmount;
        }

        @Override
        @RosettaAttribute(value="legacyReturnAmount", isRequired=true)
        @RuneAttribute(value="legacyReturnAmount", isRequired=true)
        public LegacyReturnAmount getLegacyReturnAmount() {
            return this.legacyReturnAmount;
        }

        @Override
        @RosettaAttribute(value="creditSupportAmount", isRequired=true)
        @RuneAttribute(value="creditSupportAmount", isRequired=true)
        public CreditSupportAmount getCreditSupportAmount() {
            return this.creditSupportAmount;
        }

        @Override
        @RosettaAttribute(value="collateralTransferTiming")
        @RuneAttribute(value="collateralTransferTiming")
        public CollateralTransferTiming getCollateralTransferTiming() {
            return this.collateralTransferTiming;
        }

        @Override
        public CreditSupportObligations build() {
            return this;
        }

        @Override
        public CreditSupportObligationsBuilder toBuilder() {
            CreditSupportObligationsBuilder builder = CreditSupportObligations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditSupportObligationsBuilder builder) {
            Optional.ofNullable(this.getDeliveryAmount()).ifPresent(builder::setDeliveryAmount);
            Optional.ofNullable(this.getReturnAmount()).ifPresent(builder::setReturnAmount);
            Optional.ofNullable(this.getMarginApproach()).ifPresent(builder::setMarginApproach);
            Optional.ofNullable(this.getOtherEligibleSupport()).ifPresent(builder::setOtherEligibleSupport);
            Optional.ofNullable(this.getThreshold()).ifPresent(builder::setThreshold);
            Optional.ofNullable(this.getMinimumTransferAmount()).ifPresent(builder::setMinimumTransferAmount);
            Optional.ofNullable(this.getRounding()).ifPresent(builder::setRounding);
            Optional.ofNullable(this.getBespokeTransferTiming()).ifPresent(builder::setBespokeTransferTiming);
            Optional.ofNullable(this.getCreditSupportObligationsVariationMargin()).ifPresent(builder::setCreditSupportObligationsVariationMargin);
            Optional.ofNullable(this.getLegacyThreshold()).ifPresent(builder::setLegacyThreshold);
            Optional.ofNullable(this.getLegacyMinimumTransferAmount()).ifPresent(builder::setLegacyMinimumTransferAmount);
            Optional.ofNullable(this.getLegacyDeliveryAmount()).ifPresent(builder::setLegacyDeliveryAmount);
            Optional.ofNullable(this.getLegacyReturnAmount()).ifPresent(builder::setLegacyReturnAmount);
            Optional.ofNullable(this.getCreditSupportAmount()).ifPresent(builder::setCreditSupportAmount);
            Optional.ofNullable(this.getCollateralTransferTiming()).ifPresent(builder::setCollateralTransferTiming);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditSupportObligations _that = this.getType().cast(o);
            if (!Objects.equals(this.deliveryAmount, _that.getDeliveryAmount())) {
                return false;
            }
            if (!Objects.equals(this.returnAmount, _that.getReturnAmount())) {
                return false;
            }
            if (!Objects.equals(this.marginApproach, _that.getMarginApproach())) {
                return false;
            }
            if (!Objects.equals(this.otherEligibleSupport, _that.getOtherEligibleSupport())) {
                return false;
            }
            if (!Objects.equals(this.threshold, _that.getThreshold())) {
                return false;
            }
            if (!Objects.equals(this.minimumTransferAmount, _that.getMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.rounding, _that.getRounding())) {
                return false;
            }
            if (!Objects.equals(this.bespokeTransferTiming, _that.getBespokeTransferTiming())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportObligationsVariationMargin, _that.getCreditSupportObligationsVariationMargin())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legacyThreshold, _that.getLegacyThreshold())) {
                return false;
            }
            if (!ListEquals.listEquals(this.legacyMinimumTransferAmount, _that.getLegacyMinimumTransferAmount())) {
                return false;
            }
            if (!Objects.equals(this.legacyDeliveryAmount, _that.getLegacyDeliveryAmount())) {
                return false;
            }
            if (!Objects.equals(this.legacyReturnAmount, _that.getLegacyReturnAmount())) {
                return false;
            }
            if (!Objects.equals(this.creditSupportAmount, _that.getCreditSupportAmount())) {
                return false;
            }
            return Objects.equals(this.collateralTransferTiming, _that.getCollateralTransferTiming());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.deliveryAmount != null ? this.deliveryAmount.hashCode() : 0);
            _result = 31 * _result + (this.returnAmount != null ? this.returnAmount.hashCode() : 0);
            _result = 31 * _result + (this.marginApproach != null ? this.marginApproach.hashCode() : 0);
            _result = 31 * _result + (this.otherEligibleSupport != null ? this.otherEligibleSupport.hashCode() : 0);
            _result = 31 * _result + (this.threshold != null ? this.threshold.hashCode() : 0);
            _result = 31 * _result + (this.minimumTransferAmount != null ? this.minimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.rounding != null ? this.rounding.hashCode() : 0);
            _result = 31 * _result + (this.bespokeTransferTiming != null ? this.bespokeTransferTiming.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportObligationsVariationMargin != null ? this.creditSupportObligationsVariationMargin.hashCode() : 0);
            _result = 31 * _result + (this.legacyThreshold != null ? this.legacyThreshold.hashCode() : 0);
            _result = 31 * _result + (this.legacyMinimumTransferAmount != null ? this.legacyMinimumTransferAmount.hashCode() : 0);
            _result = 31 * _result + (this.legacyDeliveryAmount != null ? this.legacyDeliveryAmount.hashCode() : 0);
            _result = 31 * _result + (this.legacyReturnAmount != null ? this.legacyReturnAmount.hashCode() : 0);
            _result = 31 * _result + (this.creditSupportAmount != null ? this.creditSupportAmount.hashCode() : 0);
            _result = 31 * _result + (this.collateralTransferTiming != null ? this.collateralTransferTiming.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditSupportObligations {deliveryAmount=" + this.deliveryAmount + ", returnAmount=" + this.returnAmount + ", marginApproach=" + this.marginApproach + ", otherEligibleSupport=" + this.otherEligibleSupport + ", threshold=" + this.threshold + ", minimumTransferAmount=" + this.minimumTransferAmount + ", rounding=" + this.rounding + ", bespokeTransferTiming=" + this.bespokeTransferTiming + ", creditSupportObligationsVariationMargin=" + this.creditSupportObligationsVariationMargin + ", legacyThreshold=" + this.legacyThreshold + ", legacyMinimumTransferAmount=" + this.legacyMinimumTransferAmount + ", legacyDeliveryAmount=" + this.legacyDeliveryAmount + ", legacyReturnAmount=" + this.legacyReturnAmount + ", creditSupportAmount=" + this.creditSupportAmount + ", collateralTransferTiming=" + this.collateralTransferTiming + '}';
        }
    }
}

