/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.processor;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.legaldocumentation.common.LegalAgreement;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.MetaFields;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class ContractualPartyMappingProcessor
extends MappingProcessor {
    public ContractualPartyMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        LegalAgreement.LegalAgreementBuilder legalAgreementBuilder = (LegalAgreement.LegalAgreementBuilder)parent;
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getContractualParty((String)party).ifPresent(partyInfo -> legalAgreementBuilder.addContractualParty(ReferenceWithMetaParty.builder().setValue((Party)partyInfo).build())));
    }

    private Optional<Party> getContractualParty(String party) {
        Party.PartyBuilder partyBuilder = Party.builder();
        this.setValueAndUpdateMappings(String.format("answers.partyA.parties.%s_name", party), value -> {
            partyBuilder.setNameValue((String)value);
            partyBuilder.setMeta((MetaFields)MetaFields.builder().setExternalKey(party));
        });
        this.setValueAndUpdateMappings(String.format("%s.entity.id", party), value -> partyBuilder.addPartyId(PartyIdentifier.builder().setIdentifierValue((String)value).build()));
        MappingProcessorUtils.updateMappings((Path)Path.parse((String)"answers.partyA.parties"), (List)this.getMappings(), (RosettaPath)this.getModelPath());
        return partyBuilder.hasData() ? Optional.of(partyBuilder.build()) : Optional.empty();
    }
}

