/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.workflow;

import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.meta.WorkflowMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Workflow", builder=WorkflowBuilderImpl.class, version="6.10.0")
@RuneDataType(value="Workflow", model="cdm", builder=WorkflowBuilderImpl.class, version="6.10.0")
public interface Workflow
extends RosettaModelObject {
    public static final WorkflowMeta metaData = new WorkflowMeta();

    public List<? extends WorkflowStep> getSteps();

    public Workflow build();

    public WorkflowBuilder toBuilder();

    public static WorkflowBuilder builder() {
        return new WorkflowBuilderImpl();
    }

    default public RosettaMetaData<? extends Workflow> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Workflow> getType() {
        return Workflow.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("steps"), processor, WorkflowStep.class, this.getSteps(), new AttributeMeta[0]);
    }

    public static class WorkflowBuilderImpl
    implements WorkflowBuilder {
        protected List<WorkflowStep.WorkflowStepBuilder> steps = new ArrayList<WorkflowStep.WorkflowStepBuilder>();

        @Override
        @RosettaAttribute(value="steps", isRequired=true)
        @RuneAttribute(value="steps", isRequired=true)
        public List<? extends WorkflowStep.WorkflowStepBuilder> getSteps() {
            return this.steps;
        }

        @Override
        public WorkflowStep.WorkflowStepBuilder getOrCreateSteps(int index) {
            if (this.steps == null) {
                this.steps = new ArrayList<WorkflowStep.WorkflowStepBuilder>();
            }
            return (WorkflowStep.WorkflowStepBuilder)this.getIndex(this.steps, index, () -> {
                WorkflowStep.WorkflowStepBuilder newSteps = WorkflowStep.builder();
                return newSteps;
            });
        }

        @Override
        @RosettaAttribute(value="steps", isRequired=true)
        @RuneAttribute(value="steps", isRequired=true)
        public WorkflowBuilder addSteps(WorkflowStep _steps) {
            if (_steps != null) {
                this.steps.add(_steps.toBuilder());
            }
            return this;
        }

        @Override
        public WorkflowBuilder addSteps(WorkflowStep _steps, int idx) {
            this.getIndex(this.steps, idx, () -> _steps.toBuilder());
            return this;
        }

        @Override
        public WorkflowBuilder addSteps(List<? extends WorkflowStep> stepss) {
            if (stepss != null) {
                for (WorkflowStep workflowStep : stepss) {
                    this.steps.add(workflowStep.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="steps")
        public WorkflowBuilder setSteps(List<? extends WorkflowStep> stepss) {
            this.steps = stepss == null ? new ArrayList<WorkflowStep.WorkflowStepBuilder>() : (List)stepss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Workflow build() {
            return new WorkflowImpl(this);
        }

        @Override
        public WorkflowBuilder toBuilder() {
            return this;
        }

        @Override
        public WorkflowBuilder prune() {
            this.steps = this.steps.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getSteps() != null && this.getSteps().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public WorkflowBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            WorkflowBuilder o = (WorkflowBuilder)other;
            merger.mergeRosetta(this.getSteps(), o.getSteps(), this::getOrCreateSteps);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Workflow _that = this.getType().cast(o);
            return ListEquals.listEquals(this.steps, _that.getSteps());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.steps != null ? this.steps.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "WorkflowBuilder {steps=" + this.steps + '}';
        }
    }

    public static interface WorkflowBuilder
    extends Workflow,
    RosettaModelObjectBuilder {
        public WorkflowStep.WorkflowStepBuilder getOrCreateSteps(int var1);

        public List<? extends WorkflowStep.WorkflowStepBuilder> getSteps();

        public WorkflowBuilder addSteps(WorkflowStep var1);

        public WorkflowBuilder addSteps(WorkflowStep var1, int var2);

        public WorkflowBuilder addSteps(List<? extends WorkflowStep> var1);

        public WorkflowBuilder setSteps(List<? extends WorkflowStep> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("steps"), processor, WorkflowStep.WorkflowStepBuilder.class, this.getSteps(), new AttributeMeta[0]);
        }

        public WorkflowBuilder prune();
    }

    public static class WorkflowImpl
    implements Workflow {
        private final List<? extends WorkflowStep> steps;

        protected WorkflowImpl(WorkflowBuilder builder) {
            this.steps = Optional.ofNullable(builder.getSteps()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="steps", isRequired=true)
        @RuneAttribute(value="steps", isRequired=true)
        public List<? extends WorkflowStep> getSteps() {
            return this.steps;
        }

        @Override
        public Workflow build() {
            return this;
        }

        @Override
        public WorkflowBuilder toBuilder() {
            WorkflowBuilder builder = Workflow.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(WorkflowBuilder builder) {
            Optional.ofNullable(this.getSteps()).ifPresent(builder::setSteps);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Workflow _that = this.getType().cast(o);
            return ListEquals.listEquals(this.steps, _that.getSteps());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.steps != null ? this.steps.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Workflow {steps=" + this.steps + '}';
        }
    }
}

