/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.event.common.Trade;
import cdm.product.qualification.functions.SettlementPayoutOnlyExists;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="TradeSettlementPayout")
@ImplementedBy(value=Default.class)
public interface TradeSettlementPayout
extends Validator<Trade> {
    public static final String NAME = "TradeSettlementPayout";
    public static final String DEFINITION = "if SettlementPayoutOnlyExists(product -> economicTerms -> payout) then partyRole -> role contains PartyRoleEnum -> Buyer and partyRole -> role contains PartyRoleEnum -> Seller and tradeLot -> priceQuantity -> price exists";

    public static class NoOp
    implements TradeSettlementPayout {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeSettlementPayout {
        @Inject
        protected SettlementPayoutOnlyExists settlementPayoutOnlyExists;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeSettlementPayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeSettlementPayout.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeSettlementPayout.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeSettlementPayout.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                Boolean _boolean = this.settlementPayoutOnlyExists.evaluate(MapperS.of((Object)trade).map("getProduct", _trade -> _trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).getMulti());
                if (_boolean != null && _boolean.booleanValue()) {
                    return ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.BUYER))).and(ExpressionOperators.contains((Mapper)MapperS.of((Object)trade).mapC("getPartyRole", _trade -> _trade.getPartyRole()).map("getRole", partyRole -> partyRole.getRole()), (Mapper)MapperS.of((Object)((Object)PartyRoleEnum.SELLER)))).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)trade).mapC("getTradeLot", _trade -> _trade.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

