/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.processor;

import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Trade;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedPartyRoleMappingProcessor
extends MappingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedPartyRoleMappingProcessor.class);

    public RelatedPartyRoleMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, List<? extends RosettaModelObjectBuilder> builder, RosettaModelObjectBuilder parent) {
        Collection<PartyRoleMapping> partyRoleMappings = this.getMappings().stream().filter(m -> synonymPath.getParent().nameStartMatches(m.getXmlPath())).collect(Collectors.groupingBy(this::getKey, Collectors.collectingAndThen(Collectors.toList(), this::toPartyRoleMapping))).values();
        partyRoleMappings.forEach(m -> {
            Trade.TradeBuilder tradeBuilder = (Trade.TradeBuilder)parent;
            if (m != null && ((PartyRoleMapping)m).role != null) {
                try {
                    PartyRoleEnum roleEnum = PartyRoleEnum.fromDisplayName(((PartyRoleMapping)m).role);
                    PartyRole.PartyRoleBuilder partyRoleBuilder = PartyRole.builder().setRole(roleEnum);
                    if (((PartyRoleMapping)m).partyReference != null) {
                        partyRoleBuilder.setPartyReference(ReferenceWithMetaParty.builder().setExternalReference(((PartyRoleMapping)m).partyReference));
                    }
                    if (((PartyRoleMapping)m).ownershipPartyReference != null) {
                        partyRoleBuilder.setOwnershipPartyReference(ReferenceWithMetaParty.builder().setExternalReference(((PartyRoleMapping)m).ownershipPartyReference));
                    }
                    tradeBuilder.addPartyRole(partyRoleBuilder);
                    if (((PartyRoleMapping)m).partyReferenceMapping != null && ((PartyRoleMapping)m).partyReferenceModelPath != null) {
                        MappingProcessorUtils.updateMappingSuccess((Mapping)((PartyRoleMapping)m).partyReferenceMapping, (RosettaPath)((PartyRoleMapping)m).partyReferenceModelPath);
                    }
                    if (((PartyRoleMapping)m).roleMapping != null && ((PartyRoleMapping)m).roleModelPath != null) {
                        MappingProcessorUtils.updateMappingSuccess((Mapping)((PartyRoleMapping)m).roleMapping, (RosettaPath)((PartyRoleMapping)m).roleModelPath);
                    }
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warn("Invalid PartyRoleEnum: " + ((PartyRoleMapping)m).role, (Throwable)e);
                }
            }
        });
    }

    private String getKey(Mapping m) {
        int partyTradeInformationIndex = this.getPathIndex(m, "partyTradeInformation");
        int relatedPartyIndex = this.getPathIndex(m, "relatedParty");
        return partyTradeInformationIndex + "-" + relatedPartyIndex;
    }

    private int getPathIndex(Mapping m, String elementName) {
        return MappingProcessorUtils.subPath((String)elementName, (Path)m.getXmlPath()).map(Path::getLastElement).map(Path.PathElement::forceGetIndex).orElse(-1);
    }

    private PartyRoleMapping toPartyRoleMapping(List<Mapping> mappings) {
        try {
            if (!mappings.isEmpty()) {
                String xmlPath = mappings.get(0).getXmlPath().toString();
                Matcher matcher = Pattern.compile(".*partyTradeInformation\\((\\d+)\\).*").matcher(xmlPath);
                if (matcher.find()) {
                    String index = matcher.group(1);
                    Pattern dynamicPattern = Pattern.compile(".*partyTradeInformation\\(" + index + "\\)\\.partyReference.*");
                    Mapping ownershipPartyReferenceMapping = this.getMapping(this.getMappings().stream().filter(m -> m.getXmlValue() != null && dynamicPattern.matcher(m.getXmlPath().toString()).matches()).collect(Collectors.toList()), Path.parse((String)"partyReference.href"));
                    RosettaPath ownershipPartyReferenceModelPath = this.getModelPath().newSubPath("ownershipPartyReference").newSubPath("externalReference");
                    Mapping partyReferenceMapping = this.getMapping(mappings.stream().filter(m -> m.getXmlValue() != null).collect(Collectors.toList()), Path.parse((String)"partyReference.href"));
                    RosettaPath partyReferenceModelPath = this.getModelPath().newSubPath("partyReference").newSubPath("externalReference");
                    Mapping roleMapping = this.getMapping(mappings.stream().filter(m -> m.getXmlValue() != null).collect(Collectors.toList()), Path.parse((String)"role"));
                    RosettaPath roleModelPath = this.getModelPath().newSubPath("role");
                    if (partyReferenceMapping != null && partyReferenceMapping.getXmlValue() != null && roleMapping != null && roleMapping.getXmlValue() != null) {
                        return new PartyRoleMapping(String.valueOf(ownershipPartyReferenceMapping.getXmlValue()), ownershipPartyReferenceMapping, ownershipPartyReferenceModelPath, String.valueOf(partyReferenceMapping.getXmlValue()), partyReferenceMapping, partyReferenceModelPath, String.valueOf(roleMapping.getXmlValue()), roleMapping, roleModelPath);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to build party role mapping from mappings {}", mappings, (Object)e);
        }
        return null;
    }

    private Mapping getMapping(List<Mapping> mappings, Path endsWith) {
        return mappings.stream().filter(m -> m.getXmlPath().endsWith(endsWith)).findFirst().orElse(null);
    }

    private static class PartyRoleMapping {
        private final String ownershipPartyReference;
        private final Mapping ownershipPartyReferenceMapping;
        private final RosettaPath ownershipPartyReferenceModelPath;
        private final String partyReference;
        private final Mapping partyReferenceMapping;
        private final RosettaPath partyReferenceModelPath;
        private final String role;
        private final Mapping roleMapping;
        private final RosettaPath roleModelPath;

        public PartyRoleMapping(String ownershipPartyReference, Mapping ownershipPartyReferenceMapping, RosettaPath ownershipPartyReferenceModelPath, String partyReference, Mapping partyReferenceMapping, RosettaPath partyReferenceModelPath, String role, Mapping roleMapping, RosettaPath roleModelPath) {
            this.ownershipPartyReference = ownershipPartyReference;
            this.ownershipPartyReferenceMapping = ownershipPartyReferenceMapping;
            this.ownershipPartyReferenceModelPath = ownershipPartyReferenceModelPath;
            this.partyReference = partyReference;
            this.partyReferenceMapping = partyReferenceMapping;
            this.partyReferenceModelPath = partyReferenceModelPath;
            this.role = role;
            this.roleMapping = roleMapping;
            this.roleModelPath = roleModelPath;
        }
    }
}

