/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.BusinessCenterTime;
import cdm.base.datetime.TimeZone;
import cdm.base.datetime.functions.TimeZoneFromBusinessCenterTime;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.observable.common.DeterminationMethodEnum;
import cdm.observable.common.TimeTypeEnum;
import cdm.observable.common.functions.ResolveTimeZoneFromTimeType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolvePerformanceValuationTimeDefault.class)
public abstract class ResolvePerformanceValuationTime
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ResolveTimeZoneFromTimeType resolveTimeZoneFromTimeType;
    @Inject
    protected TimeZoneFromBusinessCenterTime timeZoneFromBusinessCenterTime;

    public TimeZone evaluate(BusinessCenterTime valuationTime, TimeTypeEnum valuationTimeType, AssetIdentifier assetIdentifier, DeterminationMethodEnum determinationMethod) {
        TimeZone time;
        TimeZone.TimeZoneBuilder timeBuilder = this.doEvaluate(valuationTime, valuationTimeType, assetIdentifier, determinationMethod);
        if (timeBuilder == null) {
            time = null;
        } else {
            time = timeBuilder.build();
            this.objectValidator.validate(TimeZone.class, (RosettaModelObject)time);
        }
        return time;
    }

    protected abstract TimeZone.TimeZoneBuilder doEvaluate(BusinessCenterTime var1, TimeTypeEnum var2, AssetIdentifier var3, DeterminationMethodEnum var4);

    public static class ResolvePerformanceValuationTimeDefault
    extends ResolvePerformanceValuationTime {
        @Override
        protected TimeZone.TimeZoneBuilder doEvaluate(BusinessCenterTime valuationTime, TimeTypeEnum valuationTimeType, AssetIdentifier assetIdentifier, DeterminationMethodEnum determinationMethod) {
            TimeZone.TimeZoneBuilder time = TimeZone.builder();
            return this.assignOutput(time, valuationTime, valuationTimeType, assetIdentifier, determinationMethod);
        }

        protected TimeZone.TimeZoneBuilder assignOutput(TimeZone.TimeZoneBuilder time, BusinessCenterTime valuationTime, TimeTypeEnum valuationTimeType, AssetIdentifier assetIdentifier, DeterminationMethodEnum determinationMethod) {
            time = ExpressionOperators.exists((Mapper)MapperS.of((Object)valuationTime)).getOrDefault(Boolean.valueOf(false)) != false ? (TimeZone.TimeZoneBuilder)this.toBuilder(this.timeZoneFromBusinessCenterTime.evaluate(valuationTime)) : null;
            time = ExpressionOperators.exists((Mapper)MapperS.of((Object)((Object)valuationTimeType))).getOrDefault(Boolean.valueOf(false)) != false ? (TimeZone.TimeZoneBuilder)this.toBuilder(this.resolveTimeZoneFromTimeType.evaluate(assetIdentifier, valuationTimeType, determinationMethod)) : null;
            return Optional.ofNullable(time).map(o -> o.prune()).orElse(null);
        }
    }
}

