/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.asset.common.InstrumentTypeEnum;
import cdm.base.staticdata.asset.common.Security;
import cdm.event.common.functions.NewFloatingPayout;
import cdm.event.common.functions.NewSingleNameEquityPerformancePayout;
import cdm.legaldocumentation.transaction.EquitySwapMasterConfirmation2018;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=NewEquitySwapProductDefault.class)
public abstract class NewEquitySwapProduct
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected NewFloatingPayout newFloatingPayout;
    @Inject
    protected NewSingleNameEquityPerformancePayout newSingleNameEquityPerformancePayout;

    public NonTransferableProduct evaluate(Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
        NonTransferableProduct product;
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)security).map("getInstrumentType", _security -> _security.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)InstrumentTypeEnum.EQUITY)), (CardinalityOperator)CardinalityOperator.All), "Security must be equity (single name).");
        NonTransferableProduct.NonTransferableProductBuilder productBuilder = this.doEvaluate(security, masterConfirmation);
        if (productBuilder == null) {
            product = null;
        } else {
            product = productBuilder.build();
            this.objectValidator.validate(NonTransferableProduct.class, (RosettaModelObject)product);
        }
        this.conditionValidator.validate(() -> {
            if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)masterConfirmation)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg = MapperS.of((Object)product).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).mapItem(item -> ExpressionOperators.exists((Mapper)item.map("getPerformancePayout", payout -> payout.getPerformancePayout())).asMapper());
                return ComparisonResult.of((Mapper)ExpressionOperators.areEqual((Mapper)thenArg, (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).asMapper());
            }
            return ComparisonResult.successEmptyOperand((String)"");
        }, "Other payout types must be absent.");
        return product;
    }

    protected abstract NonTransferableProduct.NonTransferableProductBuilder doEvaluate(Security var1, EquitySwapMasterConfirmation2018 var2);

    public static class NewEquitySwapProductDefault
    extends NewEquitySwapProduct {
        @Override
        protected NonTransferableProduct.NonTransferableProductBuilder doEvaluate(Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            NonTransferableProduct.NonTransferableProductBuilder product = NonTransferableProduct.builder();
            return this.assignOutput(product, security, masterConfirmation);
        }

        protected NonTransferableProduct.NonTransferableProductBuilder assignOutput(NonTransferableProduct.NonTransferableProductBuilder product, Security security, EquitySwapMasterConfirmation2018 masterConfirmation) {
            Payout payout1;
            Payout payout0 = Payout.builder().setPerformancePayout(this.newSingleNameEquityPerformancePayout.evaluate(security, masterConfirmation)).build();
            product.getOrCreateEconomicTerms().addPayout(payout0 == null ? Collections.emptyList() : Collections.singletonList(payout0));
            List<Object> ifThenElseResult = ExpressionOperators.exists((Mapper)MapperS.of((Object)masterConfirmation)).getOrDefault(Boolean.valueOf(false)) != false ? ((payout1 = Payout.builder().setInterestRatePayout(this.newFloatingPayout.evaluate(masterConfirmation)).build()) == null ? Collections.emptyList() : Collections.singletonList(payout1)) : Collections.emptyList();
            product.getOrCreateEconomicTerms().addPayout(ifThenElseResult);
            return Optional.ofNullable(product).map(o -> o.prune()).orElse(null);
        }
    }
}

