/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Reset;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.product.asset.InterestRatePayout;
import cdm.product.asset.functions.FixedAmount;
import cdm.product.asset.functions.FloatingAmount;
import cdm.product.template.Payout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestCashSettlementAmountDefault.class)
public abstract class InterestCashSettlementAmount
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected FixedAmount fixedAmount;
    @Inject
    protected FloatingAmount floatingAmount;

    public Transfer evaluate(TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
        Transfer interestCashSettlementAmount;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)payout).map("getInterestRatePayout", _payout -> _payout.getInterestRatePayout())), "Payout must be an InterestRatePayout.");
        Transfer.TransferBuilder interestCashSettlementAmountBuilder = this.doEvaluate(tradeState, payout, resets, date);
        if (interestCashSettlementAmountBuilder == null) {
            interestCashSettlementAmount = null;
        } else {
            interestCashSettlementAmount = interestCashSettlementAmountBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)interestCashSettlementAmount);
        }
        return interestCashSettlementAmount;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Payout var2, List<? extends Reset> var3, Date var4);

    protected abstract MapperS<? extends InterestRatePayout> interestRatePayout(TradeState var1, Payout var2, List<? extends Reset> var3, Date var4);

    protected abstract MapperS<BigDecimal> performance(TradeState var1, Payout var2, List<? extends Reset> var3, Date var4);

    protected abstract MapperS<? extends ReferenceWithMetaParty> payer(TradeState var1, Payout var2, List<? extends Reset> var3, Date var4);

    protected abstract MapperS<? extends ReferenceWithMetaParty> receiver(TradeState var1, Payout var2, List<? extends Reset> var3, Date var4);

    public static class InterestCashSettlementAmountDefault
    extends InterestCashSettlementAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
            if (resets == null) {
                resets = Collections.emptyList();
            }
            Transfer.TransferBuilder interestCashSettlementAmount = Transfer.builder();
            return this.assignOutput(interestCashSettlementAmount, tradeState, payout, resets, date);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder interestCashSettlementAmount, TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
            interestCashSettlementAmount.getOrCreateQuantity().setValue((BigDecimal)this.performance(tradeState, payout, resets, date).get());
            interestCashSettlementAmount.getOrCreateQuantity().getOrCreateUnit().setCurrency((FieldWithMetaString)this.interestRatePayout(tradeState, payout, resets, date).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get());
            ReferenceWithMetaParty ifThenElseResult0 = ExpressionOperators.greaterThanEquals(this.performance(tradeState, payout, resets, date), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)this.payer(tradeState, payout, resets, date).get() : (ReferenceWithMetaParty)this.receiver(tradeState, payout, resets, date).get();
            interestCashSettlementAmount.getOrCreatePayerReceiver().setPayerPartyReference(ifThenElseResult0);
            ReferenceWithMetaParty ifThenElseResult1 = ExpressionOperators.greaterThanEquals(this.performance(tradeState, payout, resets, date), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)this.receiver(tradeState, payout, resets, date).get() : (ReferenceWithMetaParty)this.payer(tradeState, payout, resets, date).get();
            interestCashSettlementAmount.getOrCreatePayerReceiver().setReceiverPartyReference(ifThenElseResult1);
            interestCashSettlementAmount.getOrCreateSettlementDate().setAdjustedDate(date == null ? FieldWithMetaDate.builder().build() : FieldWithMetaDate.builder().setValue(date).build());
            interestCashSettlementAmount.setSettlementOrigin(ReferenceWithMetaPayout.builder().setGlobalReference(Optional.ofNullable(payout).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable(payout).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(interestCashSettlementAmount).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
            return MapperS.of((Object)payout).map("getInterestRatePayout", _payout -> _payout.getInterestRatePayout());
        }

        @Override
        protected MapperS<BigDecimal> performance(TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
            if (ExpressionOperators.exists((Mapper)this.interestRatePayout(tradeState, payout, resets, date).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFixedRateSpecification", rateSpecification -> rateSpecification.getFixedRateSpecification())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.fixedAmount.evaluate((InterestRatePayout)this.interestRatePayout(tradeState, payout, resets, date).get(), (BigDecimal)this.interestRatePayout(tradeState, payout, resets, date).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get(), date, null));
            }
            if (ExpressionOperators.exists((Mapper)this.interestRatePayout(tradeState, payout, resets, date).map("getRateSpecification", _interestRatePayout -> _interestRatePayout.getRateSpecification()).map("getFloatingRateSpecification", rateSpecification -> rateSpecification.getFloatingRateSpecification())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.floatingAmount.evaluate((InterestRatePayout)this.interestRatePayout(tradeState, payout, resets, date).get(), (BigDecimal)MapperS.of((Object)((Reset)MapperC.of(resets).get())).map("getResetValue", reset -> reset.getResetValue()).map("getValue", price -> price.getValue()).get(), (BigDecimal)this.interestRatePayout(tradeState, payout, resets, date).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get(), date, null));
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaParty> payer(TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.interestRatePayout(tradeState, payout, resets, date).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference());
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaParty> receiver(TradeState tradeState, Payout payout, List<? extends Reset> resets, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.interestRatePayout(tradeState, payout, resets, date).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference());
        }
    }
}

