/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Instruction;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ExtractBeforeTradeDefault.class)
public abstract class ExtractBeforeTrade
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Trade evaluate(BusinessEvent businessEvent) {
        Trade trade;
        Trade.TradeBuilder tradeBuilder = this.doEvaluate(businessEvent);
        if (tradeBuilder == null) {
            trade = null;
        } else {
            trade = tradeBuilder.build();
            this.objectValidator.validate(Trade.class, (RosettaModelObject)trade);
        }
        return trade;
    }

    protected abstract Trade.TradeBuilder doEvaluate(BusinessEvent var1);

    public static class ExtractBeforeTradeDefault
    extends ExtractBeforeTrade {
        @Override
        protected Trade.TradeBuilder doEvaluate(BusinessEvent businessEvent) {
            Trade.TradeBuilder trade = Trade.builder();
            return this.assignOutput(trade, businessEvent);
        }

        protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder trade, BusinessEvent businessEvent) {
            trade = (Trade.TradeBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((Instruction)MapperS.of((Object)businessEvent).mapC("getInstruction", _businessEvent -> _businessEvent.getInstruction()).get())).map("getBefore", instruction -> instruction.getBefore()).map("Type coercion", referenceWithMetaTradeState -> referenceWithMetaTradeState == null ? null : referenceWithMetaTradeState.getValue()).map("getTrade", tradeState -> tradeState.getTrade()).get());
            return Optional.ofNullable(trade).map(o -> o.prune()).orElse(null);
        }
    }
}

