/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrAdjustedOrRelativeDate;
import cdm.base.math.NonNegativeQuantity;
import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.Asset;
import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import cdm.base.staticdata.asset.common.Cash;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.ScheduledTransfer;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.TransferExpression;
import cdm.event.common.TransferInstruction;
import cdm.event.common.TransferState;
import cdm.observable.asset.Money;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.ScheduledTransferEnum;
import cdm.product.common.settlement.SettlementDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_OnDemandInterestPaymentPrimitiveInstructionDefault.class)
public abstract class Create_OnDemandInterestPaymentPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;

    public PrimitiveInstruction evaluate(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
        PrimitiveInstruction instruction;
        this.conditionValidator.validate(() -> ExpressionOperators.exists(this.interestRatePayout(tradeState, interestAmount, settlementDate)), "Only a contractual product with a single interest rate payout can have an on-demand interest payment.");
        this.conditionValidator.validate(() -> ExpressionOperators.areEqual((Mapper)MapperS.of((Object)interestAmount).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString0 -> fieldWithMetaString0 == null ? null : fieldWithMetaString0.getValue()), (Mapper)this.interestRatePayout(tradeState, interestAmount, settlementDate).map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule -> referenceWithMetaNonNegativeQuantitySchedule == null ? null : referenceWithMetaNonNegativeQuantitySchedule.getValue()).map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("Type coercion", fieldWithMetaString1 -> fieldWithMetaString1 == null ? null : fieldWithMetaString1.getValue()), (CardinalityOperator)CardinalityOperator.All), "The currency of the interest amount must match the currency of the original interest rate payout.");
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementDate).map("getAdjustableOrRelativeDate", _settlementDate -> _settlementDate.getAdjustableOrRelativeDate())), "The settlement date must be specified as an adjustable or relative date.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instructionBuilder = this.doEvaluate(tradeState, interestAmount, settlementDate);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, Money var2, SettlementDate var3);

    protected abstract MapperS<? extends InterestRatePayout> interestRatePayout(TradeState var1, Money var2, SettlementDate var3);

    protected abstract MapperS<? extends PartyReferencePayerReceiver> payerReceiver(TradeState var1, Money var2, SettlementDate var3);

    protected abstract MapperS<? extends Transfer> transfer(TradeState var1, Money var2, SettlementDate var3);

    public static class Create_OnDemandInterestPaymentPrimitiveInstructionDefault
    extends Create_OnDemandInterestPaymentPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, interestAmount, settlementDate);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            TransferState transferState = TransferState.builder().setTransfer((Transfer)this.transfer(tradeState, interestAmount, settlementDate).get()).build();
            instruction = (PrimitiveInstruction.PrimitiveInstructionBuilder)this.toBuilder(PrimitiveInstruction.builder().setTransfer(TransferInstruction.builder().setTransferState(transferState == null ? Collections.emptyList() : Collections.singletonList(transferState)).build()).build());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends InterestRatePayout> interestRatePayout(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            return MapperS.of((Object)((InterestRatePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getProduct", trade -> trade.getProduct()).map("getEconomicTerms", nonTransferableProduct -> nonTransferableProduct.getEconomicTerms()).mapC("getPayout", economicTerms -> economicTerms.getPayout()).map("getInterestRatePayout", payout -> payout.getInterestRatePayout()).get()));
        }

        @Override
        protected MapperS<? extends PartyReferencePayerReceiver> payerReceiver(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            return MapperS.of((Object)PartyReferencePayerReceiver.builder().setPayerPartyReference((ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.interestRatePayout(tradeState, interestAmount, settlementDate).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).map("getPayer", _payerReceiver -> _payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get()).setReceiverPartyReference((ReferenceWithMetaParty)MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).mapC("getCounterparty", trade -> trade.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.interestRatePayout(tradeState, interestAmount, settlementDate).map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).map("getReceiver", _payerReceiver -> _payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference()).get()).build());
        }

        @Override
        protected MapperS<? extends Transfer> transfer(TradeState tradeState, Money interestAmount, SettlementDate settlementDate) {
            AssetIdentifier assetIdentifier = AssetIdentifier.builder().setIdentifier((FieldWithMetaString)MapperS.of((Object)interestAmount).map("getUnit", money -> money.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get()).setIdentifierType(AssetIdTypeEnum.CURRENCY_CODE).build();
            return MapperS.of((Object)Transfer.builder().setQuantity(NonNegativeQuantity.builder().setValue((BigDecimal)MapperS.of((Object)interestAmount).map("getValue", money -> money.getValue()).get()).setUnit((UnitType)MapperS.of((Object)interestAmount).map("getUnit", money -> money.getUnit()).get()).build()).setAsset(Asset.builder().setCash(Cash.builder().setIdentifier(assetIdentifier == null ? Collections.emptyList() : Collections.singletonList(assetIdentifier)).build()).build()).setSettlementDate((AdjustableOrAdjustedOrRelativeDate)MapperS.of((Object)settlementDate).map("getAdjustableOrRelativeDate", _settlementDate -> _settlementDate.getAdjustableOrRelativeDate()).get()).setPayerReceiver((PartyReferencePayerReceiver)this.payerReceiver(tradeState, interestAmount, settlementDate).get()).setTransferExpression(TransferExpression.builder().setScheduledTransfer(ScheduledTransfer.builder().setTransferType(ScheduledTransferEnum.NET_INTEREST).build()).build()).build());
        }
    }
}

