/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.ListedDerivative;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ListedDerivativeOptions")
@ImplementedBy(value=Default.class)
public interface ListedDerivativeOptions
extends Validator<ListedDerivative> {
    public static final String NAME = "ListedDerivativeOptions";
    public static final String DEFINITION = "if optionType exists then strike exists else strike is absent";

    public static class NoOp
    implements ListedDerivativeOptions {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ListedDerivative listedDerivative) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ListedDerivativeOptions {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ListedDerivative listedDerivative) {
            ComparisonResult result = this.executeDataRule(listedDerivative);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ListedDerivativeOptions.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ListedDerivative", (RosettaPath)path, (String)ListedDerivativeOptions.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ListedDerivativeOptions.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ListedDerivative", (RosettaPath)path, (String)ListedDerivativeOptions.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ListedDerivative listedDerivative) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)listedDerivative).map("getOptionType", _listedDerivative -> _listedDerivative.getOptionType())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)listedDerivative).map("getStrike", _listedDerivative -> _listedDerivative.getStrike()));
                }
                return ExpressionOperators.notExists((Mapper)MapperS.of((Object)listedDerivative).map("getStrike", _listedDerivative -> _listedDerivative.getStrike()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

