/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.Commodity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CommodityValueSource")
@ImplementedBy(value=Default.class)
public interface CommodityValueSource
extends Validator<Commodity> {
    public static final String NAME = "CommodityValueSource";
    public static final String DEFINITION = "if taxonomy exists then (taxonomy -> source exists and taxonomy -> value exists)";

    public static class NoOp
    implements CommodityValueSource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Commodity commodity) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CommodityValueSource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Commodity commodity) {
            ComparisonResult result = this.executeDataRule(commodity);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CommodityValueSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityValueSource.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CommodityValueSource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Commodity", (RosettaPath)path, (String)CommodityValueSource.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Commodity commodity) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getTaxonomy", _commodity -> _commodity.getTaxonomy())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getTaxonomy", _commodity -> _commodity.getTaxonomy()).map("getSource", taxonomy -> taxonomy.getSource())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)commodity).mapC("getTaxonomy", _commodity -> _commodity.getTaxonomy()).map("getValue", taxonomy -> taxonomy.getValue())));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

